<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkIdentifyTextContentByParams(array $params)
 * @method getServerTimeByParams(array $params)
 * @method checkIdentifyTextContentV1ByParams(array $params)
 * @method sendAppPushByParams(array $params)
 * @method getServerTimeV1ByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 校验文本信息
     *
     * @param  array $content 校验内容 [ require true ]
     * @throws  \Exception
     * @return  string[][]
     */
    public static function checkIdentifyTextContent (array $content) {
        return self::getClass()->checkIdentifyTextContent([
            "content" => $content,
        ]);
    }

    /**
     * 获取当前服务器时间
     *
     * @throws  \Exception
     * @return  int
     */
    public static function getServerTime () {
        return self::getClass()->getServerTime();
    }

    /**
     * 校验文本信息.v1
     *
     * @param  array $content 校验内容 [ require true ]
     * @throws  \Exception
     * @return  string[][]
     */
    public static function checkIdentifyTextContentV1 (array $content) {
        return self::getClass()->checkIdentifyTextContentV1([
            "content" => $content,
        ]);
    }

    /**
     * 发送App消息
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $content 文本内容 [ require true ]
     * @support  array $fieldKeys 参数 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendAppPush () {
        return self::getClass()->sendAppPush([
        ]);
    }

    /**
     * 获取当前服务器时间.v1
     *
     * @throws  \Exception
     * @return  int
     */
    public static function getServerTimeV1 () {
        return self::getClass()->getServerTimeV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Common\Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Common\Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}