<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\OrderNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getIndexOrderByParams(array $params)
 * @method submitCharmWorkplaceByParams(array $params)
 * @method getOrderCharmWorkplaceByParams(array $params)
 * @method changeCharmWorkplaceByParams(array $params)
 * @method getIndexOrderV1ByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得首页订单
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO
     */
    public static function getIndexOrder () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexOrder(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO"
        );
    }

    /**
     * 提交职场魅力
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  string $charmType 职场魅力类型 [ require false ]
     * @support  string $attributeType 职场魅力属性 [ require true ]
     * @support  string $myIdea 我的想法 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submitCharmWorkplace () {
        return self::getClass()->submitCharmWorkplace([
        ]);
    }

    /**
     * 获取订单职场魅力信息
     *
     * @param  int $orderId 订单Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderCharmWorkplaceDTO
     */
    public static function getOrderCharmWorkplace (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderCharmWorkplace([
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderCharmWorkplaceDTO"
        );
    }

    /**
     * 编辑职场魅力
     *
     * @support  string $id 订单魅力职场信息id [ require true ]
     * @support  int $orderId 订单Id [ require true ]
     * @support  string $charmType 职场魅力类型 [ require false ]
     * @support  string $attributeType 职场魅力属性 [ require true ]
     * @support  string $myIdea 我的想法 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeCharmWorkplace () {
        return self::getClass()->changeCharmWorkplace([
        ]);
    }

    /**
     * 获得首页订单.v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO
     */
    public static function getIndexOrderV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getIndexOrderV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'OrderNew\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'OrderNew\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}