<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\ProductNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method productLayerImgByParams(array $params)
 * @method getProductTagsByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductTagsCmd $params)
 * @method getCatalogueListByParams(array $params)
 * @method getConfigCityListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ConfigCityListCmd $params)
 * @method getCategoryProductsByCityIdByParams(array $params)
 * @method getBrandRecommendByParams(array $params)
 * @method getCouldPhotoCityByParams(array $params)
 * @method getCharmWorkplaceConfigByParams(array $params)
 * @method submitCharmWorkplaceByParams(array $params)
 * @method productLayerImgV1ByParams(array $params)
 * @method getCategoryProductsByCityIdV1ByParams(array $params)
 * @method getCouldPhotoCityV1ByParams(array $params)
 * @method getCatalogueListV1ByParams(array $params)
 * @method getProductTagsV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductTagsCmd $params)
 * @method getBrandRecommendV1ByParams(array $params)
 * @method getConfigCityListV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ConfigCityListCmd $params)
 * @method getCategoryProductsByCityIdV2ByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品弹窗图片
     *
     * @support  int $id 对应类型的id [ require true ]
     * @support  string $type 类型 product_detail 产品详情 package 套餐 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO
     */
    public static function productLayerImg () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productLayerImg([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO"
        );
    }

    /**
     * 获取产品标签list
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductTagsCmd $productTagsCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTagDTO[]
     */
    public static function getProductTags (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductTagsCmd $productTagsCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProductTags($productTagsCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTagDTO[]"
        );
    }


    /**
     * 获取目录list
     *
     * @param  string $brand 对应类型的id [ require true ]
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CatalogueDTO[]
     */
    public static function getCatalogueList (string $brand, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCatalogueList([
                            "brand" => $brand,
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CatalogueDTO[]"
        );
    }

    /**
     * 获取推荐配置[猜你喜欢]
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ConfigCityListCmd $configCityListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ConfigCityListDTO
     */
    public static function getConfigCityList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ConfigCityListCmd $configCityListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getConfigCityList($configCityListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ConfigCityListDTO"
        );
    }


    /**
     * 获取某个城市下某个类目所有的产品
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $cityId 城市ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByCityId (int $cityId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByCityId([
                            "cityId" => $cityId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 获取全部推荐产品
     *
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\BrandRecommendDTO[]
     */
    public static function getBrandRecommend (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBrandRecommend([
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\BrandRecommendDTO[]"
        );
    }

    /**
     * 获取产品可拍摄城市
     *
     * @param  int $productId 产品Id [ require false ]
     * @param  int $categoryId 产品组Id [ require false ]
     * @param  int $packageId 产品Id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouldPhotoCity (int $productId = 0, int $categoryId = 0, int $packageId = 0) {
        return self::getClass()->getCouldPhotoCity([
            "productId" => $productId,
            "categoryId" => $categoryId,
            "packageId" => $packageId,
        ]);
    }

    /**
     * 获取职场魅力配置信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CharmWorkplaceDTO
     */
    public static function getCharmWorkplaceConfig () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCharmWorkplaceConfig(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CharmWorkplaceDTO"
        );
    }

    /**
     * 提交职场魅力
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  string $charmType 职场魅力类型 [ require true ]
     * @support  string $attributeType 职场魅力属性 [ require true ]
     * @support  string $myIdea 我的想法 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submitCharmWorkplace () {
        return self::getClass()->submitCharmWorkplace([
        ]);
    }

    /**
     * 获取产品弹窗图片v1
     *
     * @support  int $id 对应类型的id [ require true ]
     * @support  string $type 类型 product_detail 产品详情 package 套餐 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO
     */
    public static function productLayerImgV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productLayerImgV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO"
        );
    }

    /**
     * 获取某个城市下某个类目所有的产品.v1
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $cityId 城市ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByCityIdV1 (int $cityId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByCityIdV1([
                            "cityId" => $cityId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 获取产品可拍摄城市v1
     *
     * @param  int $productId 产品Id [ require false ]
     * @param  int $categoryId 产品组Id [ require false ]
     * @param  int $packageId 产品Id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouldPhotoCityV1 (int $productId = 0, int $categoryId = 0, int $packageId = 0) {
        return self::getClass()->getCouldPhotoCityV1([
            "productId" => $productId,
            "categoryId" => $categoryId,
            "packageId" => $packageId,
        ]);
    }

    /**
     * 获取目录list-v1
     *
     * @param  string $brand 对应类型的id [ require true ]
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CatalogueDTO[]
     */
    public static function getCatalogueListV1 (string $brand, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCatalogueListV1([
                            "brand" => $brand,
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CatalogueDTO[]"
        );
    }

    /**
     * 获取产品标签list-v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductTagsCmd $productTagsCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTagDTO[]
     */
    public static function getProductTagsV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductTagsCmd $productTagsCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProductTagsV1($productTagsCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTagDTO[]"
        );
    }


    /**
     * 获取全部推荐产品-v1
     *
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\BrandRecommendDTO[]
     */
    public static function getBrandRecommendV1 (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBrandRecommendV1([
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\BrandRecommendDTO[]"
        );
    }

    /**
     * 获取推荐配置[猜你喜欢]-v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ConfigCityListCmd $configCityListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ConfigCityListDTO
     */
    public static function getConfigCityListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ConfigCityListCmd $configCityListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getConfigCityListV1($configCityListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ConfigCityListDTO"
        );
    }


    /**
     * 获取某个城市下某个类目所有的产品.v2
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $cityId 城市ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByCityIdV2 (int $cityId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByCityIdV2([
                            "cityId" => $cityId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'ProductNew\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'ProductNew\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}