<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductDetailInStoreByParams(array $params)
 * @method getAllProductsByParams(array $params)
 * @method productTreeByParams(array $params)
 * @method getCategoryProductsByStoreIdByParams(array $params)
 * @method categoriesByParams(array $params)
 * @method haveCategoryStoreIdsByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\SameNodeStoreIdsCmd $params)
 * @method getProductGiftRuleByParams(array $params)
 * @method getProductYouLikeByParams(array $params)
 * @method productSearchByParams(array $params)
 * @method checkProductCouldOccupyByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\CheckProductCouldOccupyCmd $params)
 * @method getAllProductsV1ByParams(array $params)
 * @method productTreeV1ByParams(array $params)
 * @method categoriesV1ByParams(array $params)
 * @method getCategoryProductsByStoreIdV1ByParams(array $params)
 * @method getProductYouLikeV1ByParams(array $params)
 * @method productSearchV1ByParams(array $params)
 * @method checkProductCouldOccupyV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\CheckProductCouldOccupyCmd $params)
 * @method getProductYouLikeV2ByParams(array $params)
 * @method productTreeV2ByParams(array $params)
 * @method getCategoryProductsByStoreIdV2ByParams(array $params)
 * @method productTreeV3ByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品详情.需门店
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductBaseWithGroupServicesAndPriceAndGonggeDTO
     */
    public static function getProductDetailInStore (int $storeId, int $productId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProductDetailInStore([
                            "storeId" => $storeId,
                            "productId" => $productId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductBaseWithGroupServicesAndPriceAndGonggeDTO"
        );
    }

    /**
     * 获取所有产品
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProducts (int $storeId) {
        return self::getClass()->getAllProducts([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取某个门店的产品树
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]
     */
    public static function productTree (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productTree([
                            "storeId" => $storeId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]"
        );
    }

    /**
     * 获取一个门店下某个类目所有的产品[crm也在使用]
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByStoreId (int $storeId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByStoreId([
                            "storeId" => $storeId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 根据类目ids获取类目
     *
     * @param  array $categoryIds 类目id数组 [ require true ]
     * @param  int $cityId 城市ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO[]
     */
    public static function categories (array $categoryIds, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->categories([
                            "categoryIds" => $categoryIds,
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO[]"
        );
    }

    /**
     * 过滤出有该类目的门店ids
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\SameNodeStoreIdsCmd $sameNodeStoreIdsCmd
     * @throws  \Exception
     * @return  int[]
     */
    public static function haveCategoryStoreIds (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\SameNodeStoreIdsCmd $sameNodeStoreIdsCmd) {
        return self::getClass()->haveCategoryStoreIds($sameNodeStoreIdsCmd);
    }


    /**
     * 获取赠品规则
     *
     * @support  int $nodeId 节点ID [ require true ]
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @support  string $group 品牌分组 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\GiftRule\GiftRuleDTO[]
     */
    public static function getProductGiftRule () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProductGiftRule([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\GiftRule\GiftRuleDTO[]"
        );
    }

    /**
     * 获得猜你喜欢
     *
     * @support  string $brand 品牌标志，blue：蓝标店，gold：金标店 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductYouLike () {
        return self::getClass()->getProductYouLike([
        ]);
    }

    /**
     * 产品搜索
     *
     * @param  string $name 搜索名称 [ require true ]
     * @param  int $cityId 城市id [ require true ]
     * @param  array $modules 产品modules:himo_blue,himo_gold,mainto,himo_family,mainto_hanfu [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO
     */
    public static function productSearch (string $name, int $cityId, array $modules = []) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productSearch([
                            "name" => $name,
                            "cityId" => $cityId,
                            "modules" => $modules,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO"
        );
    }

    /**
     * 校验产品占点
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\CheckProductCouldOccupyCmd $checkProductCouldOccupyCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function checkProductCouldOccupy (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\CheckProductCouldOccupyCmd $checkProductCouldOccupyCmd) {
        return self::getClass()->checkProductCouldOccupy($checkProductCouldOccupyCmd);
    }


    /**
     * 获取所有产品.v1
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProductsV1 (int $storeId) {
        return self::getClass()->getAllProductsV1([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取某个门店的产品树v1
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productTreeV1 (int $storeId) {
        return self::getClass()->productTreeV1([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 根据类目ids获取类目.v1
     *
     * @param  array $categoryIds 类目id数组 [ require true ]
     * @param  int $cityId 城市ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO[]
     */
    public static function categoriesV1 (array $categoryIds, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->categoriesV1([
                            "categoryIds" => $categoryIds,
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO[]"
        );
    }

    /**
     * 获取一个门店下某个类目所有的产品.v1
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByStoreIdV1 (int $storeId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByStoreIdV1([
                            "storeId" => $storeId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 获得猜你喜欢.v1
     *
     * @support  array $productIds 产品ids [ require false ]
     * @support  string $brand 品牌标志，blue：蓝标店，gold：金标店 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductYouLikeV1 () {
        return self::getClass()->getProductYouLikeV1([
        ]);
    }

    /**
     * 产品搜索v1
     *
     * @param  string $name 搜索名称 [ require true ]
     * @param  int $cityId 城市id [ require true ]
     * @param  array $modules 产品modules:himo_blue,himo_gold,maainto,himo_family,mainto_hanfu [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO
     */
    public static function productSearchV1 (string $name, int $cityId, array $modules = []) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productSearchV1([
                            "name" => $name,
                            "cityId" => $cityId,
                            "modules" => $modules,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO"
        );
    }

    /**
     * 校验产品占点v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\CheckProductCouldOccupyCmd $checkProductCouldOccupyCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function checkProductCouldOccupyV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\CheckProductCouldOccupyCmd $checkProductCouldOccupyCmd) {
        return self::getClass()->checkProductCouldOccupyV1($checkProductCouldOccupyCmd);
    }


    /**
     * 获得猜你喜欢.v2
     *
     * @support  string $brand 品牌标志，blue：蓝标店，gold：金标店 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductYouLikeV2 () {
        return self::getClass()->getProductYouLikeV2([
        ]);
    }

    /**
     * 获取某个门店的产品树v2
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]
     */
    public static function productTreeV2 (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productTreeV2([
                            "storeId" => $storeId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]"
        );
    }

    /**
     * 获取一个门店下某个类目所有的产品.v2
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByStoreIdV2 (int $storeId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByStoreIdV2([
                            "storeId" => $storeId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 获取某个门店的产品树v3
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]
     */
    public static function productTreeV3 (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productTreeV3([
                            "storeId" => $storeId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}