<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method douYinRefundApplicationByParams(array $params)
 * @method douYinRefundSuccessByParams(array $params)
 * @method douYinPaidNoticeByParams(array $params)
 */
class DouYin {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 聚合订单-抖音订单退款使用中事件
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  float $refundMoney 退款金额 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function douYinRefundApplication () {
        return self::getClass()->douYinRefundApplication([
        ]);
    }

    /**
     * 聚合订单-抖音订单退款成功事件
     *
     * @support  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function douYinRefundSuccess () {
        return self::getClass()->douYinRefundSuccess([
        ]);
    }

    /**
     * 聚合订单-支付抖音订单事件
     *
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function douYinPaidNotice () {
        return self::getClass()->douYinPaidNotice([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\DouYin');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\DouYin');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}