<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStudentPreferentialByParams(array $params)
 * @method getStudentPreferentialV1ByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得学生会员产品卡/优惠券信息
     *
     * @support  int $id 卡券Id [ require true ]
     * @support  string $type 卡券类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\StudentPreferentialDTO
     */
    public static function getStudentPreferential () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStudentPreferential([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\StudentPreferentialDTO"
        );
    }

    /**
     * 获得学生会员批量产品卡/优惠券信息-v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\StudentPreferentialV1DTO
     */
    public static function getStudentPreferentialV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStudentPreferentialV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\StudentPreferentialV1DTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Preferential\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Preferential\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}