<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\CompanyShoot;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkIsSubmitShootRequirementByParams(array $params)
 * @method addCompanyShootRequirementByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\CompanyShoot\AddCompanyShootCmd $params)
 */
class CompanyShoot {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取近7天是否添加过 企业拍摄需求
     *
     * @support  int $uniqueId 唯一标识id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkIsSubmitShootRequirement () {
        return self::getClass()->checkIsSubmitShootRequirement([
        ]);
    }

    /**
     * 添加企业拍摄需求信息
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\CompanyShoot\AddCompanyShootCmd $addCompanyShootCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addCompanyShootRequirement (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\CompanyShoot\AddCompanyShootCmd $addCompanyShootCmd) {
        return self::getClass()->addCompanyShootRequirement($addCompanyShootCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'CompanyShoot\CompanyShoot');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'CompanyShoot\CompanyShoot');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}