<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderAfterPayByParams(array $params)
 * @method retailOrderAfterPayByParams(array $params)
 * @method offlineOrderAfterPayByParams(array $params)
 * @method groupOrderAfterPayByParams(array $params)
 * @method giftCardOrderAfterPayByParams(array $params)
 */
class AfterPay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拍摄订单,支付完成后的回调 hook
     *
     * @support  string $data 回调数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderAfterPay () {
        return self::getClass()->orderAfterPay([
        ]);
    }

    /**
     * 零售订单,支付完成后的回调 hook
     *
     * @support  string $data 回调数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function retailOrderAfterPay () {
        return self::getClass()->retailOrderAfterPay([
        ]);
    }

    /**
     * 线下订单,支付完成后的回调 hook
     *
     * @support  string $data 回调数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function offlineOrderAfterPay () {
        return self::getClass()->offlineOrderAfterPay([
        ]);
    }

    /**
     * 团购订单,支付完成后的回调 hook
     *
     * @support  string $data 回调数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function groupOrderAfterPay () {
        return self::getClass()->groupOrderAfterPay([
        ]);
    }

    /**
     * 礼品卡订单,支付完成后的回调 hook
     *
     * @support  string $data 回调数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function giftCardOrderAfterPay () {
        return self::getClass()->giftCardOrderAfterPay([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\AfterPay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\AfterPay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}