<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Index;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRedEnvelopeRainConfigByParams(array $params)
 * @method checkUserCouldJoinRedEnvelopeActivityByParams(array $params)
 * @method setUserJoinRedEnvelopeActivityTagByParams(array $params)
 * @method getRedEnvelopeRainConfigV1ByParams(array $params)
 * @method checkUserCouldJoinRedEnvelopeActivityV1ByParams(array $params)
 * @method setUserJoinRedEnvelopeActivityTagV1ByParams(array $params)
 */
class RedEnvelopeRain {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取红包雨相关配置
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\RedEnvelopeRainConfigDTO
     */
    public static function getRedEnvelopeRainConfig () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRedEnvelopeRainConfig(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\RedEnvelopeRainConfigDTO"
        );
    }

    /**
     * 校验用户是否可以参加红包雨活动
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function checkUserCouldJoinRedEnvelopeActivity () {
        return self::getClass()->checkUserCouldJoinRedEnvelopeActivity();
    }

    /**
     * 设置用户参加红包雨活动标记
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function setUserJoinRedEnvelopeActivityTag () {
        return self::getClass()->setUserJoinRedEnvelopeActivityTag();
    }

    /**
     * 获取红包雨相关配置.v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\RedEnvelopeRainConfigDTO
     */
    public static function getRedEnvelopeRainConfigV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRedEnvelopeRainConfigV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Index\RedEnvelopeRainConfigDTO"
        );
    }

    /**
     * 校验用户是否可以参加红包雨活动.v1
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function checkUserCouldJoinRedEnvelopeActivityV1 () {
        return self::getClass()->checkUserCouldJoinRedEnvelopeActivityV1();
    }

    /**
     * 设置用户参加红包雨活动标记.v1
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function setUserJoinRedEnvelopeActivityTagV1 () {
        return self::getClass()->setUserJoinRedEnvelopeActivityTagV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Index\RedEnvelopeRain');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Index\RedEnvelopeRain');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}