<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPayOrdersByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $params)
 * @method closePayOrdersByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $params)
 * @method zeroPayByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $params)
 * @method getPaySignByParams(array $params)
 * @method createPayOrdersV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $params)
 * @method closePayOrdersV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $params)
 * @method zeroPayV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $params)
 * @method getPaySignV1ByParams(array $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建支付
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $CreatePayOrderCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Pay\CreatePayOrderDTO
     */
    public static function createPayOrders (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $CreatePayOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createPayOrders($CreatePayOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Pay\CreatePayOrderDTO"
        );
    }


    /**
     * 关闭支付单号
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $closePayOrderCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function closePayOrders (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $closePayOrderCmd) {
        return self::getClass()->closePayOrders($closePayOrderCmd);
    }


    /**
     * 零元支付New
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $zeroPayCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function zeroPay (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $zeroPayCmd) {
        return self::getClass()->zeroPay($zeroPayCmd);
    }


    /**
     * 获取支付凭证信息
     *
     * @param  string $code 支付信息 [ require true ]
     * @param  string $paymentType 支付类型 [ require true ]
     * @param  string $paymentExtend 额外支付信息 [ require true ]
     * @param  string $type 支付单类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaySign (string $code, string $paymentType, string $paymentExtend, string $type) {
        return self::getClass()->getPaySign([
            "code" => $code,
            "paymentType" => $paymentType,
            "paymentExtend" => $paymentExtend,
            "type" => $type,
        ]);
    }

    /**
     * 创建支付.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $CreatePayOrderCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Pay\CreatePayOrderDTO
     */
    public static function createPayOrdersV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $CreatePayOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createPayOrdersV1($CreatePayOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Pay\CreatePayOrderDTO"
        );
    }


    /**
     * 关闭支付单号.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $closePayOrderCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function closePayOrdersV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $closePayOrderCmd) {
        return self::getClass()->closePayOrdersV1($closePayOrderCmd);
    }


    /**
     * 零元支付New.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $zeroPayCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function zeroPayV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $zeroPayCmd) {
        return self::getClass()->zeroPayV1($zeroPayCmd);
    }


    /**
     * 获取支付凭证信息.v1
     *
     * @param  string $code 支付信息 [ require true ]
     * @param  string $paymentType 支付类型 [ require true ]
     * @param  string $paymentExtend 额外支付信息 [ require true ]
     * @param  string $type 支付单类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaySignV1 (string $code, string $paymentType, string $paymentExtend, string $type) {
        return self::getClass()->getPaySignV1([
            "code" => $code,
            "paymentType" => $paymentType,
            "paymentExtend" => $paymentExtend,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}