<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method createGroupByParams(array $params)
 * @method closeByParams(array $params)
 * @method zeroByParams(array $params)
 * @method createPayOrdersByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $params)
 * @method closePayOrdersByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $params)
 * @method zeroPayByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $params)
 * @method getPaySignByParams(array $params)
 * @method createV1ByParams(array $params)
 * @method closeV1ByParams(array $params)
 * @method zeroV1ByParams(array $params)
 * @method createPayOrdersV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $params)
 * @method closePayOrdersV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $params)
 * @method zeroPayV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $params)
 * @method getPaySignV1ByParams(array $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建支付-废弃
     * @deprecated
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @support  float $payMoney 金额 [ require false ]
     * @support  string $openId 用户openId [ require false ]
     * @support  array $retailOrderNum 零售订单编号数组 [ require false ]
     * @support  string $offlineOrderNum 线下订单编号 [ require false ]
     * @support  array $payOrderMoney 支付金额组合 [ require false ]
     * @support  int $sendUrlStaffId 发送支付链接小伙伴 [ require false ]
     * @support  string $payUrlCreateTime 支付链接创建时间 [ require false ]
     * @support  bool $kidsGiftCard 是否是kids礼品卡创建支付订单 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 创建团购支付-废弃
     * @deprecated
     *
     * @support  string $groupOrderNum 订单号 [ require false ]
     * @support  float $payMoney 金额 [ require true ]
     * @support  string $openId 用户openId [ require false ]
     * @support  int $payType 支付类型 1:支付首款 2:支付尾款 3:支付全款 [ require true ]
     * @support  int $sendUrlStaffId 发送支付链接小伙伴 [ require false ]
     * @support  string $payUrlCreateTime 支付链接创建时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createGroup () {
        return self::getClass()->createGroup([
        ]);
    }

    /**
     * 关闭支付-废弃
     * @deprecated
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $retailOrderNum 零售订单号 [ require false ]
     * @support  string $offlineOrderNum 线下订单号 [ require false ]
     * @support  string $groupOrderNum 团购订单号 [ require false ]
     * @support  int $groupOrderType 团购订单支付类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close () {
        return self::getClass()->close([
        ]);
    }

    /**
     * 零元支付-废弃
     * @deprecated
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  array $retailOrderNum 零售订单编号数组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function zero () {
        return self::getClass()->zero([
        ]);
    }

    /**
     * 创建支付
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $CreatePayOrderCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Pay\CreatePayOrderDTO
     */
    public static function createPayOrders (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $CreatePayOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createPayOrders($CreatePayOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Pay\CreatePayOrderDTO"
        );
    }


    /**
     * 关闭支付单号[crm也在使用]
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $closePayOrderCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function closePayOrders (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $closePayOrderCmd) {
        return self::getClass()->closePayOrders($closePayOrderCmd);
    }


    /**
     * 零元支付New[crm也在使用]
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $zeroPayCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function zeroPay (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $zeroPayCmd) {
        return self::getClass()->zeroPay($zeroPayCmd);
    }


    /**
     * 获取支付凭证信息
     *
     * @param  string $code 支付信息 [ require true ]
     * @param  string $paymentType 支付类型 [ require true ]
     * @param  string $paymentExtend 额外支付信息 [ require true ]
     * @param  string $type 支付单类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaySign (string $code, string $paymentType, string $paymentExtend, string $type) {
        return self::getClass()->getPaySign([
            "code" => $code,
            "paymentType" => $paymentType,
            "paymentExtend" => $paymentExtend,
            "type" => $type,
        ]);
    }

    /**
     * 创建支付.v1
     * @deprecated
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  float $payMoney 金额 [ require false ]
     * @support  string $openId 用户openId [ require false ]
     * @support  array $retailOrderNum 零售订单编号数组 [ require false ]
     * @support  array $payOrderMoney 支付金额组合 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createV1 () {
        return self::getClass()->createV1([
        ]);
    }

    /**
     * 关闭支付.v1
     * @deprecated
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeV1 () {
        return self::getClass()->closeV1([
        ]);
    }

    /**
     * 零元支付.v1
     * @deprecated
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function zeroV1 () {
        return self::getClass()->zeroV1([
        ]);
    }

    /**
     * 创建支付.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $CreatePayOrderCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Pay\CreatePayOrderDTO
     */
    public static function createPayOrdersV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\CreatePayOrderCmd $CreatePayOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createPayOrdersV1($CreatePayOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Pay\CreatePayOrderDTO"
        );
    }


    /**
     * 关闭支付单号.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $closePayOrderCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function closePayOrdersV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ClosePayOrderCmd $closePayOrderCmd) {
        return self::getClass()->closePayOrdersV1($closePayOrderCmd);
    }


    /**
     * 零元支付New.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $zeroPayCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function zeroPayV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\ZeroPayCmd $zeroPayCmd) {
        return self::getClass()->zeroPayV1($zeroPayCmd);
    }


    /**
     * 获取支付凭证信息.v1
     *
     * @param  string $code 支付信息 [ require true ]
     * @param  string $paymentType 支付类型 [ require true ]
     * @param  string $paymentExtend 额外支付信息 [ require true ]
     * @param  string $type 支付单类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaySignV1 (string $code, string $paymentType, string $paymentExtend, string $type) {
        return self::getClass()->getPaySignV1([
            "code" => $code,
            "paymentType" => $paymentType,
            "paymentExtend" => $paymentExtend,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}