<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInvisibleCaptchaV1ByParams(array $params)
 * @method getSmsCodeWithInvisibleV1ByParams(array $params)
 * @method getGeeTestRegisterByParams(array $params)
 * @method getGeeTestValidateByParams(array $params)
 * @method getSmsCodeByTokenByParams(array $params)
 * @method getSmsCodeByTokenV1ByParams(array $params)
 * @method getGeeTestRegisterV1ByParams(array $params)
 * @method getGeeTestValidateV1ByParams(array $params)
 */
class Notify {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * [腾讯]无痕验证.v1
     *
     * @support  string $captchaId 无痕验证应用ID，可不传，默认default [ require false ]
     * @support  string $phone 手机号码 [ require true ]
     * @support  string $ticket 前端回调ticket [ require true ]
     * @support  string $randStr 前端回调randstr [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInvisibleCaptchaV1 () {
        return self::getClass()->getInvisibleCaptchaV1([
        ]);
    }

    /**
     * 通过无痕验证后发送短信验证码.v1
     *
     * @param  string $type 发送类型，默认：haimati_sms_code [ require false ]
     * @param  string $phone 发送手机号码 [ require true ]
     * @param  string $token Token验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCodeWithInvisibleV1 (string $type = 'haimati_sms_code', string $phone, string $token) {
        return self::getClass()->getSmsCodeWithInvisibleV1([
            "type" => $type,
            "phone" => $phone,
            "token" => $token,
        ]);
    }

    /**
     * 极验初始化验证
     *
     * @support  string $clientType 客户端类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGeeTestRegister () {
        return self::getClass()->getGeeTestRegister([
        ]);
    }

    /**
     * 二次验证
     *
     * @support  string $geeTestChallenge 流水号，一次完整验证流程的唯一标识 [ require false ]
     * @support  string $geeTestValidate validate [ require false ]
     * @support  string $geeTestSecCode 核心校验数据 [ require false ]
     * @support  string $phone 核心校验数据 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGeeTestValidate () {
        return self::getClass()->getGeeTestValidate([
        ]);
    }

    /**
     * 根据token发送短信验证码
     *
     * @support  string $type 发送类型 [ require true ]
     * @support  string $phone 发送手机号码 [ require false ]
     * @support  string $token Token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCodeByToken () {
        return self::getClass()->getSmsCodeByToken([
        ]);
    }

    /**
     * 根据token发送验证码
     *
     * @support  string $type 发送类型 [ require true ]
     * @support  string $phone 发送手机号码 [ require false ]
     * @support  string $token Token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCodeByTokenV1 () {
        return self::getClass()->getSmsCodeByTokenV1([
        ]);
    }

    /**
     * 极验初始化验证/v1
     *
     * @support  string $clientType 客户端类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGeeTestRegisterV1 () {
        return self::getClass()->getGeeTestRegisterV1([
        ]);
    }

    /**
     * 二次验证/v1
     *
     * @support  string $geeTestChallenge 流水号，一次完整验证流程的唯一标识 [ require false ]
     * @support  string $geeTestValidate validate [ require false ]
     * @support  string $geeTestSecCode 核心校验数据 [ require false ]
     * @support  string $phone 核心校验数据 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGeeTestValidateV1 () {
        return self::getClass()->getGeeTestValidateV1([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\Notify');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\Notify');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}