<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Invoice;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\InvoiceTitleCreateCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\InvoiceTitleUpdateCmd $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method detailByParams(array $params)
 * @method searchCompanyListByParams(array $params)
 * @method searchCompanyInfoByParams(array $params)
 */
class InvoiceTitle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加发票抬头
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\InvoiceTitleCreateCmd $invoiceTitleCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\InvoiceTitleCreateCmd $invoiceTitleCreateCmd) {
        return self::getClass()->create($invoiceTitleCreateCmd);
    }


    /**
     * 编辑发票抬头
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\InvoiceTitleUpdateCmd $invoiceTitleUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\InvoiceTitleUpdateCmd $invoiceTitleUpdateCmd) {
        return self::getClass()->update($invoiceTitleUpdateCmd);
    }


    /**
     * 获取发票抬头列表
     *
     * @support  string $invoiceTitleType 抬头类型 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\InvoiceTitleListDTO
     */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\InvoiceTitleListDTO"
        );
    }

    /**
     * 删除发票抬头列表
     *
     * @support  int $id 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 获取发票抬头详情
     *
     * @support  int $id 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\InvoiceTitleInfoDTO
     */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\InvoiceTitleInfoDTO"
        );
    }

    /**
     * 搜索发票抬头列表
     *
     * @support  string $name 发票抬头 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\SearchInvoiceTitleListDTO
     */
    public static function searchCompanyList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchCompanyList([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\SearchInvoiceTitleListDTO"
        );
    }

    /**
     * 搜索发票抬头详情
     *
     * @support  string $code 查询发票抬头返回的code [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\SearchInvoiceTitleInfoDTO
     */
    public static function searchCompanyInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchCompanyInfo([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\SearchInvoiceTitleInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Invoice\InvoiceTitle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Invoice\InvoiceTitle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}