<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method productDiscountByParams(array $params)
 * @method productDiscountV1ByParams(array $params)
 */
class ProductDiscount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店折扣详情
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\DiscountRule\DiscountRuleDTO[]
     */
    public static function productDiscount (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productDiscount([
                            "storeId" => $storeId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\DiscountRule\DiscountRuleDTO[]"
        );
    }

    /**
     * 获取门店折扣详情.v1
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\DiscountRule\DiscountRuleDTO[]
     */
    public static function productDiscountV1 (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productDiscountV1([
                            "storeId" => $storeId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\DiscountRule\DiscountRuleDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Product\ProductDiscount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Product\ProductDiscount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}