<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method createMultiOrderByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $params)
 * @method orderPayAfterDetailByParams(array $params)
 * @method detailByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $params)
 * @method encodeOrderDetailByParams(array $params)
 * @method listByParams(array $params)
 * @method cancelByParams(array $params)
 * @method deleteByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method getRefundReasonByParams(array $params)
 * @method getUserConsumeStoreIdsByParams(array $params)
 * @method orderAllRefundByParams(array $params)
 * @method photoByParams(array $params)
 * @method changeAppointmentByParams(array $params)
 * @method sendOrderShareCouponByParams(array $params)
 * @method createOrderV1ByParams(array $params)
 * @method detailV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $params)
 * @method listV1ByParams(array $params)
 * @method cancelV1ByParams(array $params)
 * @method deleteV1ByParams(array $params)
 * @method getRefundReasonV1ByParams(array $params)
 * @method getUserConsumeStoreIdsV1ByParams(array $params)
 * @method changeAppointmentV1ByParams(array $params)
 * @method createMultiOrderV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $params)
 * @method orderPayAfterDetailV1ByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userBirthday 用户生日 [ require false ]
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userEmail 用户邮箱 [ require false ]
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $couponId 优惠券ID [ require false ]
     * @support  float $couponDeductionMoney 优惠券优惠金额 [ require false ]
     * @support  float $giftCardMoney 礼品卡抵扣金额 [ require false ]
     * @support  float $oriMoney 原始价格 [ require true ]
     * @support  int $productCardId 产品卡ID [ require false ]
     * @support  float $productCardDeductionMoney 产品卡优惠金额 [ require false ]
     * @support  array $productDiscountIds 组合优惠id [ require false ]
     * @support  float $productDiscountDeductionMoney 组合优惠优惠金额 [ require false ]
     * @support  int $channel 渠道号 [ require false ]
     * @support  int $gestationalWeek 孕周 [ require false ]
     * @support  string $note 备注 [ require false ]
     * @support  string $contact 联系人 [ require false ]
     * @support  string $platform 平台 [ require false ]
     * @support  array $detail 下单产品详情 [ require false ]
     * @support  array $retailDetail 下单零售产品产品详情 [ require false ]
     * @support  float $peopleDiscountMoney 人头优惠金额 [ require false ]
     * @support  float $packageDiscountMoney 套餐优惠金额 [ require false ]
     * @support  array $packageDiscountIds 套餐优惠id [ require false ]
     * @support  float $retailGiftCardMoney 零售礼品卡抵扣金额 [ require false ]
     * @support  bool $exchangeBirthGift 是否兑换生日礼遇 [ require false ]
     * @support  int $activityId 活动id [ require false ]
     * @support  int $activityMemberParentId 活动成员的上级id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder () {
        return self::getClass()->createOrder([
        ]);
    }

    /**
     * 多门店下单
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $createOrderCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderResDTO
     */
    public static function createMultiOrder (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $createOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createMultiOrder($createOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderResDTO"
        );
    }


    /**
     * 订单支付页详情
     *
     * @support  array $orderNums 订单编号s [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderPayAfterInfoDTO[]
     */
    public static function orderPayAfterDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderPayAfterDetail([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderPayAfterInfoDTO[]"
        );
    }

    /**
     * 订单详情
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $orderDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO
     */
    public static function detail (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $orderDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($orderDetailCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO"
        );
    }


    /**
     * 加密订单详情
     *
     * @support  string $encodeOrderNum 订单编号 [ require true ]
     * @support  int $diffId 未支付id [ require false ]
     * @support  string $diffType 未支付类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO
     */
    public static function encodeOrderDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->encodeOrderDetail([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO"
        );
    }

    /**
     * 订单列表
     *
     * @support  string $status 订单状态- total:全部, wait:待拍摄, process:当日拍摄, complete:已完成, close:已关闭 submit:待支付 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListDTO
     */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListDTO"
        );
    }

    /**
     * 用户取消订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel([
        ]);
    }

    /**
     * 用户删除订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 绑定订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindUser () {
        return self::getClass()->bindUser([
        ]);
    }

    /**
     * 退款理由
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\OrderRefund\RefundReasonDTO[]
     */
    public static function getRefundReason () {
        return self::getClass()->getRefundReason();
    }

    /**
     * 用户消费门店
     *
     * @throws  \Exception
     * @return  int[]
     */
    public static function getUserConsumeStoreIds () {
        return self::getClass()->getUserConsumeStoreIds();
    }

    /**
     * 订单全部退款hook
     *
     * @support  int $orderId 订单id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  array $closedSaleIds sale ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderAllRefund () {
        return self::getClass()->orderAllRefund([
        ]);
    }

    /**
     * 获取云端原片地址
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Photo\OrderPhotoDTO
     */
    public static function photo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->photo([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Photo\OrderPhotoDTO"
        );
    }

    /**
     * 修改预约
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $reserveTime 新预约时间 [ require false ]
     * @support  int $storeId 新预约门店ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeAppointment () {
        return self::getClass()->changeAppointment([
        ]);
    }

    /**
     * 发送分享优惠券
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendOrderShareCoupon () {
        return self::getClass()->sendOrderShareCoupon([
        ]);
    }

    /**
     * 创建订单.v1
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userBirthday 用户生日 [ require true ]
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userEmail 用户邮箱 [ require false ]
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $couponId 优惠券ID [ require false ]
     * @support  float $couponDeductionMoney 优惠券优惠金额 [ require false ]
     * @support  float $giftCardMoney 礼品卡抵扣金额 [ require false ]
     * @support  float $oriMoney 原始价格 [ require true ]
     * @support  int $productCardId 产品卡ID [ require false ]
     * @support  float $productCardDeductionMoney 产品卡优惠金额 [ require false ]
     * @support  array $productDiscountIds 组合优惠id [ require false ]
     * @support  float $productDiscountDeductionMoney 组合优惠优惠金额 [ require false ]
     * @support  int $channel 渠道号 [ require false ]
     * @support  int $gestationalWeek 孕周 [ require false ]
     * @support  string $note 备注 [ require false ]
     * @support  string $contact 联系人 [ require false ]
     * @support  string $platform 平台 [ require false ]
     * @support  array $detail 下单产品详情 [ require false ]
     * @support  array $retailDetail 下单零售产品产品详情 [ require false ]
     * @support  float $peopleDiscountMoney 人头优惠金额 [ require false ]
     * @support  float $packageDiscountMoney 套餐优惠金额 [ require false ]
     * @support  array $packageDiscountIds 套餐优惠id [ require false ]
     * @support  float $retailGiftCardMoney 零售礼品卡抵扣金额 [ require false ]
     * @support  bool $exchangeBirthGift 是否兑换生日礼遇 [ require false ]
     * @support  bool $exchangeBirthGift 是否兑换生日礼遇 [ require false ]
     * @support  int $activityId 活动id [ require false ]
     * @support  int $activityMemberParentId 活动成员的上级id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrderV1 () {
        return self::getClass()->createOrderV1([
        ]);
    }

    /**
     * 订单详情.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $orderDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO
     */
    public static function detailV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $orderDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detailV1($orderDetailCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO"
        );
    }


    /**
     * 订单列表.v1
     *
     * @support  string $status 订单状态- total:全部, submit:待支付, wait:待拍摄, process:当日拍摄, complete:已完成, close:已关闭 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listV1 () {
        return self::getClass()->listV1([
        ]);
    }

    /**
     * 用户取消订单.v1
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelV1 () {
        return self::getClass()->cancelV1([
        ]);
    }

    /**
     * 用户删除订单.v1
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteV1 () {
        return self::getClass()->deleteV1([
        ]);
    }

    /**
     * 退款理由.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRefundReasonV1 () {
        return self::getClass()->getRefundReasonV1();
    }

    /**
     * 用户消费门店.v1
     *
     * @throws  \Exception
     * @return  int[]
     */
    public static function getUserConsumeStoreIdsV1 () {
        return self::getClass()->getUserConsumeStoreIdsV1();
    }

    /**
     * 修改预约V1
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $reserveTime 新预约时间 [ require true ]
     * @support  int $storeId 新预约门店ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeAppointmentV1 () {
        return self::getClass()->changeAppointmentV1([
        ]);
    }

    /**
     * 多门店下单.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $createOrderCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderResDTO
     */
    public static function createMultiOrderV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $createOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createMultiOrderV1($createOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderResDTO"
        );
    }


    /**
     * 订单支付页详情
     *
     * @support  array $orderNums 订单编号s [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderPayAfterInfoDTO[]
     */
    public static function orderPayAfterDetailV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderPayAfterDetailV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderPayAfterInfoDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}