<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method testByParams(array $params)
 * @method orderAfterPayByParams(array $params)
 * @method retailOrderAfterPayByParams(array $params)
 * @method offlineOrderAfterPayByParams(array $params)
 * @method groupOrderAfterPayByParams(array $params)
 * @method giftCardOrderAfterPayByParams(array $params)
 */
class AfterPay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 支付完成后的回调data
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function test () {
        return self::getClass()->test();
    }

    /**
     * 拍摄订单,支付完成后的回调 hook
     *
     * @support  string $data 回调数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderAfterPay ($context) {
        return self::getClass()->orderAfterPay([
            "context" => $context,
        ]);
    }

    /**
     * 零售订单,支付完成后的回调 hook
     *
     * @support  string $data 回调数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function retailOrderAfterPay ($context) {
        return self::getClass()->retailOrderAfterPay([
            "context" => $context,
        ]);
    }

    /**
     * 线下订单,支付完成后的回调 hook
     *
     * @support  string $data 回调数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function offlineOrderAfterPay ($context) {
        return self::getClass()->offlineOrderAfterPay([
            "context" => $context,
        ]);
    }

    /**
     * 团购订单,支付完成后的回调 hook
     *
     * @support  string $data 回调数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function groupOrderAfterPay ($context) {
        return self::getClass()->groupOrderAfterPay([
            "context" => $context,
        ]);
    }

    /**
     * 礼品卡订单,支付完成后的回调 hook
     *
     * @support  string $data 回调数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function giftCardOrderAfterPay ($context) {
        return self::getClass()->giftCardOrderAfterPay([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\AfterPay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\AfterPay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}