<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bindCouponByParams(array $params)
 * @method couponListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CouponListCmd $params)
 * @method availableCouponListByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户绑定优惠券
     * @deprecated
     *
     * @support  string $couponCode 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindCoupon ($context) {
        return self::getClass()->bindCoupon([
            "context" => $context,
        ]);
    }

    /**
     * 优惠券列表
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CouponListCmd $couponListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO
     */
    public static function couponList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CouponListCmd $couponListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->couponList($couponListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO"
        );
    }


    /**
     * 获取产品或产品组可用优惠券列表
     * @deprecated
     *
     * @support  array $productIds 产品ids [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  array $productGroupIds 产品组ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function availableCouponList ($context) {
        return self::getClass()->availableCouponList([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Preferential\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Preferential\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}