<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Question;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getNpsStatusByParams(array $params)
 * @method createNpsByParams(array|Nps\CreateNps\CreateNpsCmd $params)
 * @method getNpsQuestionByParams(array $params)
 * @method getNpsStatusV1ByParams(array $params)
 * @method createNpsV1ByParams(array|Nps\CreateNpsV1\CreateNpsCmd $params)
 * @method getNpsQuestionV1ByParams(array $params)
 */
class Nps {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取NPS状态
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getNpsStatus () {
        return self::getClass()->getNpsStatus();
    }

    /**
     * 提交NPS问卷
     *
     * @var  Nps\CreateNps\CreateNpsCmd $createNpsCmd $createNpsCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createNps (Nps\CreateNps\CreateNpsCmd $createNpsCmd) {
        return self::getClass()->createNps($createNpsCmd);
    }


    /**
     * 获取NPS问卷
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNpsQuestion () {
        return self::getClass()->getNpsQuestion();
    }

    /**
     * 获取NPS状态.v1
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getNpsStatusV1 () {
        return self::getClass()->getNpsStatusV1();
    }

    /**
     * 提交NPS问卷.v1
     *
     * @var  Nps\CreateNpsV1\CreateNpsCmd $createNpsCmd $createNpsCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createNpsV1 (Nps\CreateNpsV1\CreateNpsCmd $createNpsCmd) {
        return self::getClass()->createNpsV1($createNpsCmd);
    }


    /**
     * 获取NPS问卷.v1
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNpsQuestionV1 () {
        return self::getClass()->getNpsQuestionV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Question\Nps');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Question\Nps');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}