<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMessageListV1ByParams(array $params)
 * @method getMessageStatusByUserIdV1ByParams(array $params)
 * @method updateMessageStatusByUserIdV1ByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取消息列表.v1
     *
     * @param  int $page 分页 [ require true ]
     * @param  int $pageSize 每页数据量 [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  Message\GetMessageListV1\MessageListDTO
     */
    public static function getMessageListV1 (int $userId, int $page = 1, int $pageSize = 10) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getMessageListV1([
                            "userId" => $userId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\User\Message\GetMessageListV1\MessageListDTO"
        );
    }

    /**
     * 获取消息状态是否未读.v1
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getMessageStatusByUserIdV1 (int $userId) {
        return self::getClass()->getMessageStatusByUserIdV1([
            "userId" => $userId,
        ]);
    }

    /**
     * 更新消息状态为已读.v1
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateMessageStatusByUserIdV1 (int $userId) {
        return self::getClass()->updateMessageStatusByUserIdV1([
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}