<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method batchDeleteByParams(array $params)
 * @method deleteByParams(array $params)
 * @method createByParams(array $params)
 */
class SearchTerms {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取历史搜索词
     *
     * @throws  \Exception
     * @return  SearchTerms\ListSafeNamespace\SearchTermInfoDTO[]
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 批量删除搜索词
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function batchDelete () {
        return self::getClass()->batchDelete();
    }

    /**
     * 删除搜索词
     *
     * @support  string $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 添加搜索词
     *
     * @support  string $content 搜索内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Product\SearchTerms');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Product\SearchTerms');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}