<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Index;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getIndexArticleByParams(array $params)
 * @method getIndexArticleListByParams(array|Index\GetIndexArticleList\IndexArticleListCmd $params)
 * @method getIndexArticleDetailByParams(array $params)
 */
class Index {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 首页热门资讯
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  string $channel 渠道 [ require true ]
     * @throws  \Exception
     * @return  Index\GetIndexArticle\IndexArticleDTO[]
     */
    public static function getIndexArticle (int $cityId = 0, string $channel) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getIndexArticle([
                            "cityId" => $cityId,
                            "channel" => $channel,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\Index\Index\GetIndexArticle\IndexArticleDTO[]"
        );
    }

    /**
     * 首页热门资讯列表
     *
     * @var  Index\GetIndexArticleList\IndexArticleListCmd $indexArticleListCmd $indexArticleListCmd
     * @throws  \Exception
     * @return  Index\GetIndexArticleList\IndexArticleListDTO
     */
    public static function getIndexArticleList (Index\GetIndexArticleList\IndexArticleListCmd $indexArticleListCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getIndexArticleList($indexArticleListCmd),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\Index\Index\GetIndexArticleList\IndexArticleListDTO"
        );
    }


    /**
     * 首页热门资讯详情
     *
     * @param  int $cityArticleId 城市文章id [ require true ]
     * @throws  \Exception
     * @return  Index\GetIndexArticleDetail\IndexArticleDTO
     */
    public static function getIndexArticleDetail (int $cityArticleId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getIndexArticleDetail([
                            "cityArticleId" => $cityArticleId,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\Index\Index\GetIndexArticleDetail\IndexArticleDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Index\Index');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Index\Index');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}