<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method editUserInfoByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserInfoCmd $params)
 * @method editUserTagByParams(array $params)
 * @method getProfessionsByParams(array $params)
 * @method getPreferencesByParams(array $params)
 * @method bindEmailByParams(array $params)
 * @method checkSignByParams(array $params)
 * @method sendCouponByParams(array $params)
 * @method setProtocolVersionByParams(array $params)
 * @method feedbackByParams(array $params)
 * @method changePasswordDirectByParams(array $params)
 * @method forgetUserPasswordByParams(array $params)
 * @method registerByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\RegisterCmd $params)
 * @method searchUserByUnionIdByParams(array $params)
 * @method detailV1ByParams(array $params)
 * @method editUserInfoV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserInfoCmd $params)
 * @method editUserTagV1ByParams(array $params)
 * @method getProfessionsV1ByParams(array $params)
 * @method getPreferencesV1ByParams(array $params)
 * @method setProtocolVersionV1ByParams(array $params)
 * @method feedbackV1ByParams(array $params)
 * @method changePasswordDirectV1ByParams(array $params)
 * @method forgetUserPasswordV1ByParams(array $params)
 * @method changUserPasswordV1ByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户详情
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
     */
    public static function detail ($context) {
        return self::getClass()->detail();
    }

    /**
     * 修改用户信息
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserInfoCmd $editUserInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
     */
    public static function editUserInfo (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserInfoCmd $editUserInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->editUserInfo($editUserInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }


    /**
     * 修改用户标签
     *
     * @support  array $preference 偏好的数组 [ require false ]
     * @support  array $purpose 用途的数组 [ require false ]
     * @support  bool $enablePush 接受推送 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
     */
    public static function editUserTag ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->editUserTag([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }

    /**
     * 职业列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Profession\ProfessionInfoDTO[]
     */
    public static function getProfessions () {
        return self::getClass()->getProfessions();
    }

    /**
     * 偏好列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preference\PreferenceListDTO
     */
    public static function getPreferences () {
        return self::getClass()->getPreferences();
    }

    /**
     * 绑定邮箱
     *
     * @support  string $email 邮箱地址 [ require true ]
     * @support  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindEmail ($context) {
        return self::getClass()->bindEmail([
            "context" => $context,
        ]);
    }

    /**
     * 绑定邮箱校验是否通过验证
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  int $user_id 用户uid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkSign (string $brand, int $user_id) {
        return self::getClass()->checkSign([
            "brand" => $brand,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 绑定邮箱发放优惠券
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  int $user_id 用户id [ require true ]
     * @param  string $choose 选择的券 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendCoupon (string $brand, int $user_id, string $choose) {
        return self::getClass()->sendCoupon([
            "brand" => $brand,
            "user_id" => $user_id,
            "choose" => $choose,
        ]);
    }

    /**
     * 记录预约协议版本
     *
     * @support  int $protocolVersion 预约协议版本 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setProtocolVersion ($context) {
        return self::getClass()->setProtocolVersion([
            "context" => $context,
        ]);
    }

    /**
     * 用户意见反馈
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function feedback ($context) {
        return self::getClass()->feedback([
            "context" => $context,
        ]);
    }

    /**
     * 更改密码（密码为空）
     *
     * @support  string $password 新密码 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changePasswordDirect ($context) {
        return self::getClass()->changePasswordDirect([
            "context" => $context,
        ]);
    }

    /**
     * 通过验证码更改登录密码
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $password 新密码 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function forgetUserPassword (string $phone, string $password, string $captcha) {
        return self::getClass()->forgetUserPassword([
            "phone" => $phone,
            "password" => $password,
            "captcha" => $captcha,
        ]);
    }

    /**
     * 注册
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\RegisterCmd $registerCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function register (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\RegisterCmd $registerCmd) {
        return self::getClass()->register($registerCmd);
    }


    /**
     * 通过unionId判断用户是否在海马体平台注册过
     *
     * @support  string $unionId unionId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchUserByUnionId ($context) {
        return self::getClass()->searchUserByUnionId([
            "context" => $context,
        ]);
    }

    /**
     * 用户详情.v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
     */
    public static function detailV1 ($context) {
        return self::getClass()->detailV1();
    }

    /**
     * 修改用户信息.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserInfoCmd $editUserInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
     */
    public static function editUserInfoV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserInfoCmd $editUserInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->editUserInfoV1($editUserInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }


    /**
     * 修改用户标签.v1
     *
     * @support  array $preference 偏好的数组 [ require false ]
     * @support  array $purpose 用途的数组 [ require false ]
     * @support  bool $enablePush 接受推送 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
     */
    public static function editUserTagV1 ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->editUserTagV1([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }

    /**
     * 职业列表.v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Profession\ProfessionInfoDTO[]
     */
    public static function getProfessionsV1 () {
        return self::getClass()->getProfessionsV1();
    }

    /**
     * 偏好列表.v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preference\PreferenceListDTO
     */
    public static function getPreferencesV1 () {
        return self::getClass()->getPreferencesV1();
    }

    /**
     * 记录预约协议版本.v1
     *
     * @support  int $protocolVersion 预约协议版本 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setProtocolVersionV1 ($context) {
        return self::getClass()->setProtocolVersionV1([
            "context" => $context,
        ]);
    }

    /**
     * 用户意见反馈.v1
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function feedbackV1 ($context) {
        return self::getClass()->feedbackV1([
            "context" => $context,
        ]);
    }

    /**
     * 更改密码（密码为空）.v1
     *
     * @support  string $password 新密码 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changePasswordDirectV1 ($context) {
        return self::getClass()->changePasswordDirectV1([
            "context" => $context,
        ]);
    }

    /**
     * 通过验证码更改登录密码.v1
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $password 新密码 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function forgetUserPasswordV1 (string $phone, string $password, string $captcha) {
        return self::getClass()->forgetUserPasswordV1([
            "phone" => $phone,
            "password" => $password,
            "captcha" => $captcha,
        ]);
    }

    /**
     * 更改密码.v1
     *
     * @param  string $password 旧密码 [ require true ]
     * @param  string $passwordNew 新密码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changUserPasswordV1 ($context, string $password, string $passwordNew) {
        return self::getClass()->changUserPasswordV1([
            "context" => $context,
            "password" => $password,
            "passwordNew" => $passwordNew,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}