<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getWxMiniSchemeByParams(array|Wx\GetWxMiniScheme\WxSchemeCmd $params)
 * @method getWxMiniUrlLinkByParams(array|Wx\GetWxMiniUrlLink\WxUrlLinkCmd $params)
 */
class Wx {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成小程序scheme码
     *
     * @var  Wx\GetWxMiniScheme\WxSchemeCmd $wxSchemeCmd $wxSchemeCmd
     * @throws  \Exception
     * @return  Wx\GetWxMiniScheme\WxSchemeDTO
     */
    public static function getWxMiniScheme (Wx\GetWxMiniScheme\WxSchemeCmd $wxSchemeCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getWxMiniScheme($wxSchemeCmd),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\Common\Wx\GetWxMiniScheme\WxSchemeDTO"
        );
    }


    /**
     * 生成小程序UrlLink
     *
     * @var  Wx\GetWxMiniUrlLink\WxUrlLinkCmd $wxUrlLinkCmd $wxUrlLinkCmd
     * @throws  \Exception
     * @return  Wx\GetWxMiniUrlLink\WxUrlLinkDTO
     */
    public static function getWxMiniUrlLink (Wx\GetWxMiniUrlLink\WxUrlLinkCmd $wxUrlLinkCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getWxMiniUrlLink($wxUrlLinkCmd),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\Common\Wx\GetWxMiniUrlLink\WxUrlLinkDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Common\Wx');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Common\Wx');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}