<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Appointment;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method appointmentLookPhotoDataByParams(array $params)
 * @method enableAppointmentTimeListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $params)
 * @method setAppointmentTimeByParams(array $params)
 * @method updateAppointmentTimeByParams(array $params)
 * @method cancelAppointmentTimeByParams(array $params)
 * @method allowLookPhotoStoreListByParams(array $params)
 * @method lookPhotoAppointmentStateByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $params)
 * @method appointmentLookPhotoDataV1ByParams(array $params)
 * @method enableAppointmentTimeListV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $params)
 * @method setAppointmentTimeV1ByParams(array $params)
 * @method updateAppointmentTimeV1ByParams(array $params)
 * @method cancelAppointmentTimeV1ByParams(array $params)
 * @method allowLookPhotoStoreListV1ByParams(array $params)
 * @method lookPhotoAppointmentStateV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $params)
 */
class AppointmentLookPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约看片首页
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoDataDTO
     */
    public static function appointmentLookPhotoData ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->appointmentLookPhotoData([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoDataDTO"
        );
    }

    /**
     * 可预约看片时间列表
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $appointmentTimeListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\AppointmentTimeInfoDTO[]
     */
    public static function enableAppointmentTimeList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $appointmentTimeListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->enableAppointmentTimeList($appointmentTimeListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\AppointmentTimeInfoDTO[]"
        );
    }


    /**
     * 设置预约看片时间
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $appointmentTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO
     */
    public static function setAppointmentTime ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->setAppointmentTime([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO"
        );
    }

    /**
     * 更改预约看片时间
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $appointmentTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO
     */
    public static function updateAppointmentTime ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->updateAppointmentTime([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO"
        );
    }

    /**
     * 取消预约看片时间
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelAppointmentTime ($context) {
        return self::getClass()->cancelAppointmentTime([
            "context" => $context,
        ]);
    }

    /**
     * 获取可看片门店
     *
     * @support  string $dateStart 当前开始时间,当天内 [ require false ]
     * @support  string $dateEnd 当前结束时间,当天内 [ require false ]
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $cityId 城市id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AppointmentStoreInfoDTO[]
     */
    public static function allowLookPhotoStoreList ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->allowLookPhotoStoreList([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AppointmentStoreInfoDTO[]"
        );
    }

    /**
     * 根据日期期间获取预约看片状态是否已约满
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $enableAppointmentTimeCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]
     */
    public static function lookPhotoAppointmentState (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $enableAppointmentTimeCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->lookPhotoAppointmentState($enableAppointmentTimeCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]"
        );
    }


    /**
     * 预约看片首页.v1
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoDataDTO
     */
    public static function appointmentLookPhotoDataV1 ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->appointmentLookPhotoDataV1([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoDataDTO"
        );
    }

    /**
     * 可预约看片时间列表.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $appointmentTimeListCmd
     * @throws  \Exception
     * @return  array
     */
    public static function enableAppointmentTimeListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $appointmentTimeListCmd) {
        return self::getClass()->enableAppointmentTimeListV1($appointmentTimeListCmd);
    }


    /**
     * 设置预约看片时间.v1
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $appointmentTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO
     */
    public static function setAppointmentTimeV1 ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->setAppointmentTimeV1([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO"
        );
    }

    /**
     * 更改预约看片时间.v1
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $appointmentTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO
     */
    public static function updateAppointmentTimeV1 ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->updateAppointmentTimeV1([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoAppointInfoDTO"
        );
    }

    /**
     * 取消预约看片时间.v1
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelAppointmentTimeV1 ($context) {
        return self::getClass()->cancelAppointmentTimeV1([
            "context" => $context,
        ]);
    }

    /**
     * 获取可看片门店.v1
     *
     * @support  string $dateStart 当前开始时间,当天内 [ require false ]
     * @support  string $dateEnd 当前结束时间,当天内 [ require false ]
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $cityId 城市id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AppointmentStoreInfoDTO[]
     */
    public static function allowLookPhotoStoreListV1 ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->allowLookPhotoStoreListV1([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AppointmentStoreInfoDTO[]"
        );
    }

    /**
     * 根据日期期间获取预约看片状态是否已约满v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $enableAppointmentTimeCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]
     */
    public static function lookPhotoAppointmentStateV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Appointment\EnableAppointmentTimeCmd $enableAppointmentTimeCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->lookPhotoAppointmentStateV1($enableAppointmentTimeCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Reservation\ReservationAppointmentStateDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Appointment\AppointmentLookPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Appointment\AppointmentLookPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}