<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\ProductNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method productLayerImgByParams(array $params)
 * @method getProductTagsByParams(array|Product\GetProductTags\ProductTagsCmd $params)
 * @method getCatalogueListByParams(array $params)
 * @method getConfigCityListByParams(array|Product\GetConfigCityList\ConfigCityListCmd $params)
 * @method getCategoryProductsByAreaIdByParams(array $params)
 * @method productLayerImgV1ByParams(array $params)
 * @method getCategoryProductsByAreaIdV1ByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品弹窗图片
     *
     * @support  int $id 对应类型的id [ require true ]
     * @support  string $type 类型 product_detail 产品详情 package 套餐 require false
     * @throws  \Exception
     * @return  Product\ProductLayerImg\ProductLayerImgDTO
     */
    public static function productLayerImg () {
        return self::getClass()->productLayerImg();
    }

    /**
     * 获取产品标签list
     *
     * @var  Product\GetProductTags\ProductTagsCmd $productTagsCmd $productTagsCmd
     * @throws  \Exception
     * @return  Product\GetProductTags\ProductTagTreeDTO
     */
    public static function getProductTags (Product\GetProductTags\ProductTagsCmd $productTagsCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getProductTags($productTagsCmd),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\ProductNew\Product\GetProductTags\ProductTagTreeDTO"
        );
    }


    /**
     * 获取目录list
     *
     * @param  string $brand 对应类型的id [ require true ]
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  Product\GetCatalogueList\CatalogueDTO[]
     */
    public static function getCatalogueList (string $brand, int $cityId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getCatalogueList([
                            "brand" => $brand,
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\ProductNew\Product\GetCatalogueList\CatalogueDTO[]"
        );
    }

    /**
     * 获取产品标签list
     *
     * @var  Product\GetConfigCityList\ConfigCityListCmd $configCityListCmd $configCityListCmd
     * @throws  \Exception
     * @return  Product\GetConfigCityList\ConfigCityListDTO
     */
    public static function getConfigCityList (Product\GetConfigCityList\ConfigCityListCmd $configCityListCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getConfigCityList($configCityListCmd),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\ProductNew\Product\GetConfigCityList\ConfigCityListDTO"
        );
    }


    /**
     * 获取某个城市下某个类目所有的产品
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $areaId 城市ID [ require true ]
     * @throws  \Exception
     * @return  Product\GetCategoryProductsByAreaId\ProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByAreaId (int $areaId, int $categoryId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getCategoryProductsByAreaId([
                            "areaId" => $areaId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\ProductNew\Product\GetCategoryProductsByAreaId\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 获取产品弹窗图片v1
     *
     * @support  int $id 对应类型的id [ require true ]
     * @support  string $type 类型 product_detail 产品详情 package 套餐 require false
     * @throws  \Exception
     * @return  Product\ProductLayerImgV1\ProductLayerImgDTO
     */
    public static function productLayerImgV1 () {
        return self::getClass()->productLayerImgV1();
    }

    /**
     * 获取某个城市下某个类目所有的产品.v1
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $areaId 城市ID [ require true ]
     * @throws  \Exception
     * @return  Product\GetCategoryProductsByAreaIdV1\ProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByAreaIdV1 (int $areaId, int $categoryId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getCategoryProductsByAreaIdV1([
                            "areaId" => $areaId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\ProductNew\Product\GetCategoryProductsByAreaIdV1\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'ProductNew\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'ProductNew\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}