<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\ProductNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method productLayerImgByParams(array $params)
 * @method getProductTagsByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductTagsCmd $params)
 * @method getCatalogueListByParams(array $params)
 * @method getConfigCityListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ConfigCityListCmd $params)
 * @method getCategoryProductsByAreaIdByParams(array $params)
 * @method getBrandRecommendByParams(array $params)
 * @method productLayerImgV1ByParams(array $params)
 * @method getCategoryProductsByAreaIdV1ByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品弹窗图片
     *
     * @support  int $id 对应类型的id [ require true ]
     * @support  string $type 类型 product_detail 产品详情 package 套餐 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO
     */
    public static function productLayerImg ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productLayerImg([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO"
        );
    }

    /**
     * 获取产品标签list
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductTagsCmd $productTagsCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTagDTO[]
     */
    public static function getProductTags (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductTagsCmd $productTagsCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProductTags($productTagsCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTagDTO[]"
        );
    }


    /**
     * 获取目录list
     *
     * @param  string $brand 对应类型的id [ require true ]
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CatalogueDTO[]
     */
    public static function getCatalogueList (string $brand, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCatalogueList([
                            "brand" => $brand,
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CatalogueDTO[]"
        );
    }

    /**
     * 获取推荐配置[猜你喜欢]
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ConfigCityListCmd $configCityListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ConfigCityListDTO
     */
    public static function getConfigCityList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ConfigCityListCmd $configCityListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getConfigCityList($configCityListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ConfigCityListDTO"
        );
    }


    /**
     * 获取某个城市下某个类目所有的产品
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $areaId 城市ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByAreaId (int $areaId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByAreaId([
                            "areaId" => $areaId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 获取全部推荐产品
     *
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\BrandRecommendDTO[]
     */
    public static function getBrandRecommend (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBrandRecommend([
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\BrandRecommendDTO[]"
        );
    }

    /**
     * 获取产品弹窗图片v1
     *
     * @support  int $id 对应类型的id [ require true ]
     * @support  string $type 类型 product_detail 产品详情 package 套餐 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO
     */
    public static function productLayerImgV1 ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productLayerImgV1([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO"
        );
    }

    /**
     * 获取某个城市下某个类目所有的产品.v1
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $areaId 城市ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByAreaIdV1 (int $areaId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByAreaIdV1([
                            "areaId" => $areaId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'ProductNew\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'ProductNew\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}