<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\ProductNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method packageListByAreaByParams(array $params)
 * @method packageInfoByAreaByParams(array $params)
 * @method subPackageListByAreaByParams(array $params)
 * @method packageListByAreaV1ByParams(array $params)
 * @method packageInfoByAreaV1ByParams(array $params)
 * @method subPackageListByAreaV1ByParams(array $params)
 */
class ProductPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取某个城市可展示的套餐列表
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  string $module 产品模块 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO[]
     */
    public static function packageListByArea (int $cityId, string $module) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->packageListByArea([
                            "cityId" => $cityId,
                            "module" => $module,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO[]"
        );
    }

    /**
     * 获取某个套餐的详情信息
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  string $module 产品模块 [ require true ]
     * @param  int $packageId 套餐Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO
     */
    public static function packageInfoByArea (int $cityId, string $module, int $packageId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->packageInfoByArea([
                            "cityId" => $cityId,
                            "module" => $module,
                            "packageId" => $packageId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO"
        );
    }

    /**
     * 获取某些产品组/产品关联的子套餐信息
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  string $module 产品模块 [ require true ]
     * @param  array $ids 产品ids/产品组ids [ require true ]
     * @param  string $type photographyCategory/photographyProduct [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductSubPackageDTO[]
     */
    public static function subPackageListByArea (int $cityId, string $module, array $ids, string $type) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->subPackageListByArea([
                            "cityId" => $cityId,
                            "module" => $module,
                            "ids" => $ids,
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductSubPackageDTO[]"
        );
    }

    /**
     * 获取某个城市可展示的套餐列表.v1
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  string $module 产品模块 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO[]
     */
    public static function packageListByAreaV1 (int $cityId, string $module) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->packageListByAreaV1([
                            "cityId" => $cityId,
                            "module" => $module,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO[]"
        );
    }

    /**
     * 获取某个套餐的详情信息.v1
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  string $module 产品模块 [ require true ]
     * @param  int $packageId 套餐Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO
     */
    public static function packageInfoByAreaV1 (int $cityId, string $module, int $packageId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->packageInfoByAreaV1([
                            "cityId" => $cityId,
                            "module" => $module,
                            "packageId" => $packageId,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO"
        );
    }

    /**
     * 获取某些产品组/产品关联的子套餐信息.v1
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  string $module 产品模块 [ require true ]
     * @param  array $ids 产品ids/产品组ids [ require true ]
     * @param  string $type photographyCategory/photographyProduct [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductSubPackageDTO[]
     */
    public static function subPackageListByAreaV1 (int $cityId, string $module, array $ids, string $type) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->subPackageListByAreaV1([
                            "cityId" => $cityId,
                            "module" => $module,
                            "ids" => $ids,
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductSubPackageDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'ProductNew\ProductPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'ProductNew\ProductPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}