<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bindPreferentialByParams(array $params)
 * @method replaceProductCardByParams(array $params)
 * @method getUserCouponAndProductCardsByParams(array $params)
 * @method bindPreferentialV1ByParams(array $params)
 * @method replaceProductCardV1ByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户绑定优惠券
     *
     * @support  string $preferentialCode 兑换码 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\BindPreferentialDTO
     */
    public static function bindPreferential ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->bindPreferential([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\BindPreferentialDTO"
        );
    }

    /**
     * 置换产品卡
     *
     * @support  string $replaceType 替换类型 [ require false ]
     * @support  int $productCardId 替换类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function replaceProductCard ($context) {
        return self::getClass()->replaceProductCard([
            "context" => $context,
        ]);
    }

    /**
     * 获取用户可用优惠券和产品卡.v1.无产品ids
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\UserCouponAndProductCardDTO
     */
    public static function getUserCouponAndProductCards ($context) {
        return self::getClass()->getUserCouponAndProductCards();
    }

    /**
     * 用户绑定优惠券
     *
     * @support  string $preferentialCode 兑换码 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\BindPreferentialDTO
     */
    public static function bindPreferentialV1 ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->bindPreferentialV1([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\BindPreferentialDTO"
        );
    }

    /**
     * 置换产品卡v1
     *
     * @support  string $replaceType 替换类型 [ require false ]
     * @support  int $productCardId 替换类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function replaceProductCardV1 ($context) {
        return self::getClass()->replaceProductCardV1([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}