<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\ShopCart;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBestMatchStoresByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $params)
 * @method infoByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $params)
 * @method addShopCartByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartAddCmd $params)
 * @method updateShopCartByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $params)
 * @method deleteShopCartByParams(array $params)
 * @method getBestMatchStoresV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $params)
 * @method infoV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $params)
 * @method addShopCartV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartAddCmd $params)
 * @method updateShopCartV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $params)
 * @method deleteShopCartV1ByParams(array $params)
 */
class ShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取推荐门店
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $bestMatchStoresCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\BestMatchStoreMapDTO
     */
    public static function getBestMatchStores (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $bestMatchStoresCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBestMatchStores($bestMatchStoresCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\BestMatchStoreMapDTO"
        );
    }


    /**
     * 获取购物车内容
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $shopCartInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO
     */
    public static function info (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $shopCartInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->info($shopCartInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO"
        );
    }


    /**
     * 添加购物车
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartAddCmd $shopCartAddCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartAddDTO
     */
    public static function addShopCart (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartAddCmd $shopCartAddCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->addShopCart($shopCartAddCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartAddDTO"
        );
    }


    /**
     * 更新购物车所选产品
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $shopCartUpdateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartUpdateDTO
     */
    public static function updateShopCart (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $shopCartUpdateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->updateShopCart($shopCartUpdateCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartUpdateDTO"
        );
    }


    /**
     * 删除购物车所选类目
     *
     * @support  array $shopCartIds 拍摄产品/零售 购物车id集合 [ require false ]
     * @support  array $retailIds 套餐或其他的零售购物车ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteShopCart ($context) {
        return self::getClass()->deleteShopCart([
            "context" => $context,
        ]);
    }

    /**
     * 获取推荐门店.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $bestMatchStoresCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\BestMatchStoreMapDTO
     */
    public static function getBestMatchStoresV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $bestMatchStoresCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBestMatchStoresV1($bestMatchStoresCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\BestMatchStoreMapDTO"
        );
    }


    /**
     * 获取购物车内容.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $shopCartInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO
     */
    public static function infoV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $shopCartInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->infoV1($shopCartInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO"
        );
    }


    /**
     * 添加购物车.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartAddCmd $shopCartAddCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartAddDTO
     */
    public static function addShopCartV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartAddCmd $shopCartAddCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->addShopCartV1($shopCartAddCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartAddDTO"
        );
    }


    /**
     * 更新购物车所选产品.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $shopCartUpdateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartUpdateDTO
     */
    public static function updateShopCartV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $shopCartUpdateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->updateShopCartV1($shopCartUpdateCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartUpdateDTO"
        );
    }


    /**
     * 删除购物车所选类目.v1
     *
     * @support  array $shopCartIds 拍摄产品/零售 购物车id集合 [ require false ]
     * @support  array $retailIds 套餐或其他的零售购物车ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteShopCartV1 ($context) {
        return self::getClass()->deleteShopCartV1([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'ShopCart\ShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'ShopCart\ShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}