<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method choosePoseByParams(array $params)
 * @method choosePoseOneHoursByParams(array $params)
 */
class OrdersCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拍前选拍摄动作-提前24小时 发送未拍前选拍摄动作的提醒
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function choosePose () {
        return self::getClass()->choosePose();
    }

    /**
     * 拍前选拍摄动作-(用户创建时间和拍摄时间&lt; 24 小时，提前一天发送拍前选拍摄动作提醒)发送未拍前选拍摄动作的提醒
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function choosePoseOneHours () {
        return self::getClass()->choosePoseOneHours();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Cron\OrdersCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Cron\OrdersCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}