<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getShareOrderListByParams(array $params)
 * @method getShareOrderCategoriesByParams(array $params)
 * @method createShareOrderByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShareOrder\ShareOrderCreateCmd $params)
 * @method deleteShareOrderByParams(array $params)
 * @method getShareOrderListV1ByParams(array $params)
 * @method getShareOrderCategoriesV1ByParams(array $params)
 * @method createShareOrderV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShareOrder\ShareOrderCreateCmd $params)
 * @method deleteShareOrderV1ByParams(array $params)
 */
class ShareOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得买家秀列表
     *
     * @support  int $categoryId 类目ID [ require true ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO
     */
    public static function getShareOrderList ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShareOrderList([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO"
        );
    }

    /**
     * 获得晒单类目数据
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO
     */
    public static function getShareOrderCategories ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShareOrderCategories([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO"
        );
    }

    /**
     * 提交晒单数据
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShareOrder\ShareOrderCreateCmd $shareOrderCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createShareOrder (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShareOrder\ShareOrderCreateCmd $shareOrderCreateCmd) {
        return self::getClass()->createShareOrder($shareOrderCreateCmd);
    }


    /**
     * 删除买家秀
     *
     * @support  int $shareId 晒单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteShareOrder ($context) {
        return self::getClass()->deleteShareOrder([
            "context" => $context,
        ]);
    }

    /**
     * 获得买家秀列表.V1
     *
     * @support  int $categoryId 类目ID [ require true ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO
     */
    public static function getShareOrderListV1 ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShareOrderListV1([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO"
        );
    }

    /**
     * 获得晒单类目数据.v1
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO
     */
    public static function getShareOrderCategoriesV1 ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShareOrderCategoriesV1([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO"
        );
    }

    /**
     * 提交晒单数据.V1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShareOrder\ShareOrderCreateCmd $shareOrderCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createShareOrderV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShareOrder\ShareOrderCreateCmd $shareOrderCreateCmd) {
        return self::getClass()->createShareOrderV1($shareOrderCreateCmd);
    }


    /**
     * 删除买家秀.v1
     *
     * @support  int $shareId 晒单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteShareOrderV1 ($context) {
        return self::getClass()->deleteShareOrderV1([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\ShareOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\ShareOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}