<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Invoice;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceTitleCreateCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceTitleUpdateCmd $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method detailByParams(array $params)
 * @method searchCompanyListByParams(array $params)
 * @method searchCompanyInfoByParams(array $params)
 */
class InvoiceTitle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加发票抬头
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceTitleCreateCmd $invoiceTitleCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceTitleCreateCmd $invoiceTitleCreateCmd) {
        return self::getClass()->create($invoiceTitleCreateCmd);
    }


    /**
     * 编辑发票抬头
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceTitleUpdateCmd $invoiceTitleUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceTitleUpdateCmd $invoiceTitleUpdateCmd) {
        return self::getClass()->update($invoiceTitleUpdateCmd);
    }


    /**
     * 获取发票抬头列表
     *
     * @support  string $invoiceTitleType 抬头类型 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceTitleListDTO
     */
    public static function list ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceTitleListDTO"
        );
    }

    /**
     * 删除发票抬头列表
     *
     * @support  int $id 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete ($context) {
        return self::getClass()->delete([
            "context" => $context,
        ]);
    }

    /**
     * 获取发票抬头详情
     *
     * @support  int $id 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceTitleInfoDTO
     */
    public static function detail ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\InvoiceTitleInfoDTO"
        );
    }

    /**
     * 搜索发票抬头列表
     *
     * @support  string $name 发票抬头 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\SearchInvoiceTitleListDTO
     */
    public static function searchCompanyList ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchCompanyList([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\SearchInvoiceTitleListDTO"
        );
    }

    /**
     * 搜索发票抬头详情
     *
     * @support  string $code 查询发票抬头返回的code [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\SearchInvoiceTitleInfoDTO
     */
    public static function searchCompanyInfo ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchCompanyInfo([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserInvoice\SearchInvoiceTitleInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Invoice\InvoiceTitle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Invoice\InvoiceTitle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}