<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenUpdateProductByParams(array $params)
 * @method listenUpdateCategoryByParams(array $params)
 * @method listenChangeProductWithPriceByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 编辑产品通知
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function listenUpdateProduct (int $productId) {
        return self::getClass()->listenUpdateProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 编辑类目通知
     *
     * @param  int $categoryId 类目id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function listenUpdateCategory (int $categoryId) {
        return self::getClass()->listenUpdateCategory([
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 产品和价格变更通知
     *
     * @param  int $productId 产品id [ require true ]
     * @param  int $priceId 价格id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function listenChangeProductWithPrice (int $productId, int $priceId) {
        return self::getClass()->listenChangeProductWithPrice([
            "productId" => $productId,
            "priceId" => $priceId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}