<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method agreeAuthorizationByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserStartLight\StarLightAgreeAuthorizationCmd $params)
 */
class StarLight {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单下所有照片
     *
     * @support  string $code 加密订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserStartLight\StarLightDetailDTO
     */
    public static function detail ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserStartLight\StarLightDetailDTO"
        );
    }

    /**
     * 同意授权
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserStartLight\StarLightAgreeAuthorizationCmd $starLightAgreeAuthorizationCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function agreeAuthorization (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserStartLight\StarLightAgreeAuthorizationCmd $starLightAgreeAuthorizationCmd) {
        return self::getClass()->agreeAuthorization($starLightAgreeAuthorizationCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\StarLight');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\StarLight');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}