<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bindProductCardByParams(array $params)
 * @method productCardListByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ProductCardListCmd $params)
 * @method availableProductCardListByParams(array $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户绑定产品卡
     * @deprecated
     *
     * @support  string $productCardCode 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindProductCard ($context) {
        return self::getClass()->bindProductCard([
            "context" => $context,
        ]);
    }

    /**
     * 产品卡列表
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ProductCardListCmd $productCardListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardListDTO
     */
    public static function productCardList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ProductCardListCmd $productCardListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productCardList($productCardListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardListDTO"
        );
    }


    /**
     * 获取产品可用产品卡列表
     * @deprecated
     *
     * @support  array $productIds 产品id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function availableProductCardList ($context) {
        return self::getClass()->availableProductCardList([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Preferential\ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Preferential\ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}