<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method confirmByParams(array $params)
 */
class CustomerPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取顾客原片信息
     *
     * @support  string $sign 凭证 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 确认授权
     *
     * @support  string $sign 凭证 [ require false ]
     * @support  array $photos 授权图片数组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirm () {
        return self::getClass()->confirm([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\CustomerPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\CustomerPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}