<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Discuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method myListByParams(array $params)
 * @method addByParams(array $params)
 * @method editByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method likeByParams(array $params)
 * @method likeCancelByParams(array $params)
 */
class Wish {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 心愿列表.首页
     *
     * @support  string $status 实现状态 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 心愿列表.个人列表
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function myList ($context) {
        return self::getClass()->myList([
            "context" => $context,
        ]);
    }

    /**
     * 心愿添加
     *
     * @support  string $content 心愿内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add ($context) {
        return self::getClass()->add([
            "context" => $context,
        ]);
    }

    /**
     * 心愿编辑
     *
     * @support  int $id 心愿id [ require true ]
     * @support  string $content 心愿内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit ($context) {
        return self::getClass()->edit([
            "context" => $context,
        ]);
    }

    /**
     * 心愿详情
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail ($context) {
        return self::getClass()->detail([
            "context" => $context,
        ]);
    }

    /**
     * 心愿删除
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete ($context) {
        return self::getClass()->delete([
            "context" => $context,
        ]);
    }

    /**
     * 心愿点赞
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function like ($context) {
        return self::getClass()->like([
            "context" => $context,
        ]);
    }

    /**
     * 心愿点赞取消
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function likeCancel ($context) {
        return self::getClass()->likeCancel([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Discuss\Wish');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Discuss\Wish');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}