<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method createMultiOrderByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $params)
 * @method detailByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $params)
 * @method encodeOrderDetailByParams(array $params)
 * @method listByParams(array $params)
 * @method cancelByParams(array $params)
 * @method deleteByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method refundByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method getRefundReasonByParams(array $params)
 * @method getUserConsumeStoreIdsByParams(array $params)
 * @method orderAllRefundByParams(array $params)
 * @method photoByParams(array $params)
 * @method changeAppointmentByParams(array $params)
 * @method sendOrderShareCouponByParams(array $params)
 * @method createOrderV1ByParams(array $params)
 * @method detailV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $params)
 * @method listV1ByParams(array $params)
 * @method cancelV1ByParams(array $params)
 * @method deleteV1ByParams(array $params)
 * @method refundV1ByParams(array $params)
 * @method changeReserveTimeV1ByParams(array $params)
 * @method getRefundReasonV1ByParams(array $params)
 * @method getUserConsumeStoreIdsV1ByParams(array $params)
 * @method changeAppointmentV1ByParams(array $params)
 * @method createMultiOrderV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userBirthday 用户生日 [ require false ]
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userEmail 用户邮箱 [ require false ]
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $couponId 优惠券ID [ require false ]
     * @support  float $couponDeductionMoney 优惠券优惠金额 [ require false ]
     * @support  float $giftCardMoney 礼品卡抵扣金额 [ require false ]
     * @support  float $oriMoney 原始价格 [ require true ]
     * @support  int $productCardId 产品卡ID [ require false ]
     * @support  float $productCardDeductionMoney 产品卡优惠金额 [ require false ]
     * @support  array $productDiscountIds 组合优惠id [ require false ]
     * @support  float $productDiscountDeductionMoney 组合优惠优惠金额 [ require false ]
     * @support  int $channel 渠道号 [ require false ]
     * @support  int $gestationalWeek 孕周 [ require false ]
     * @support  string $note 备注 [ require false ]
     * @support  string $contact 联系人 [ require false ]
     * @support  string $platform 平台 [ require false ]
     * @support  array $detail 下单产品详情 [ require false ]
     * @support  array $retailDetail 下单零售产品产品详情 [ require false ]
     * @support  float $peopleDiscountMoney 人头优惠金额 [ require false ]
     * @support  float $packageDiscountMoney 套餐优惠金额 [ require false ]
     * @support  array $packageDiscountIds 套餐优惠id [ require false ]
     * @support  float $retailGiftCardMoney 零售礼品卡抵扣金额 [ require false ]
     * @support  bool $exchangeBirthGift 是否兑换生日礼遇 [ require false ]
     * @support  int $activityId 活动id [ require false ]
     * @support  int $activityMemberParentId 活动成员的上级id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder ($context) {
        return self::getClass()->createOrder([
            "context" => $context,
        ]);
    }

    /**
     * 多门店下单
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $createOrderCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderDTO[]
     */
    public static function createMultiOrder (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $createOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createMultiOrder($createOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderDTO[]"
        );
    }


    /**
     * 订单详情
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $orderDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO
     */
    public static function detail (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $orderDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($orderDetailCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO"
        );
    }


    /**
     * 加密订单详情
     *
     * @support  string $encodeOrderNum 订单编号 [ require true ]
     * @support  int $diffId 未支付id [ require false ]
     * @support  string $diffType 未支付类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO
     */
    public static function encodeOrderDetail ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->encodeOrderDetail([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO"
        );
    }

    /**
     * 订单列表
     *
     * @support  string $status 订单状态- total:全部, wait:待拍摄, process:当日拍摄, complete:已完成, close:已关闭 submit:待支付 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListDTO
     */
    public static function list ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListDTO"
        );
    }

    /**
     * 用户取消订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel ($context) {
        return self::getClass()->cancel([
            "context" => $context,
        ]);
    }

    /**
     * 用户删除订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete ($context) {
        return self::getClass()->delete([
            "context" => $context,
        ]);
    }

    /**
     * 绑定订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindUser ($context) {
        return self::getClass()->bindUser([
            "context" => $context,
        ]);
    }

    /**
     * 订单退款.退礼品卡
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  array $reasonIds 退款原因ids [ require false ]
     * @support  string $reason 退款原因 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refund ($context) {
        return self::getClass()->refund([
            "context" => $context,
        ]);
    }

    /**
     * 修改预约时间
     * @deprecated
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $reserveTime 新预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime ($context) {
        return self::getClass()->changeReserveTime([
            "context" => $context,
        ]);
    }

    /**
     * 退款理由
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\OrderRefund\RefundReasonDTO[]
     */
    public static function getRefundReason () {
        return self::getClass()->getRefundReason();
    }

    /**
     * 用户消费门店
     *
     * @throws  \Exception
     * @return  int[]
     */
    public static function getUserConsumeStoreIds ($context) {
        return self::getClass()->getUserConsumeStoreIds();
    }

    /**
     * 订单全部退款hook
     *
     * @support  int $orderId 订单id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  array $closedSaleIds sale ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderAllRefund ($context) {
        return self::getClass()->orderAllRefund([
            "context" => $context,
        ]);
    }

    /**
     * 获取云端原片地址
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Photo\OrderPhotoDTO
     */
    public static function photo ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->photo([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Photo\OrderPhotoDTO"
        );
    }

    /**
     * 修改预约
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $reserveTime 新预约时间 [ require false ]
     * @support  int $storeId 新预约门店ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeAppointment ($context) {
        return self::getClass()->changeAppointment([
            "context" => $context,
        ]);
    }

    /**
     * 发送分享优惠券
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendOrderShareCoupon ($context) {
        return self::getClass()->sendOrderShareCoupon([
            "context" => $context,
        ]);
    }

    /**
     * 创建订单.v1
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userBirthday 用户生日 [ require true ]
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userEmail 用户邮箱 [ require false ]
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $couponId 优惠券ID [ require false ]
     * @support  float $couponDeductionMoney 优惠券优惠金额 [ require false ]
     * @support  float $giftCardMoney 礼品卡抵扣金额 [ require false ]
     * @support  float $oriMoney 原始价格 [ require true ]
     * @support  int $productCardId 产品卡ID [ require false ]
     * @support  float $productCardDeductionMoney 产品卡优惠金额 [ require false ]
     * @support  array $productDiscountIds 组合优惠id [ require false ]
     * @support  float $productDiscountDeductionMoney 组合优惠优惠金额 [ require false ]
     * @support  int $channel 渠道号 [ require false ]
     * @support  int $gestationalWeek 孕周 [ require false ]
     * @support  string $note 备注 [ require false ]
     * @support  string $contact 联系人 [ require false ]
     * @support  string $platform 平台 [ require false ]
     * @support  array $detail 下单产品详情 [ require false ]
     * @support  array $retailDetail 下单零售产品产品详情 [ require false ]
     * @support  float $peopleDiscountMoney 人头优惠金额 [ require false ]
     * @support  float $packageDiscountMoney 套餐优惠金额 [ require false ]
     * @support  array $packageDiscountIds 套餐优惠id [ require false ]
     * @support  float $retailGiftCardMoney 零售礼品卡抵扣金额 [ require false ]
     * @support  bool $exchangeBirthGift 是否兑换生日礼遇 [ require false ]
     * @support  bool $exchangeBirthGift 是否兑换生日礼遇 [ require false ]
     * @support  int $activityId 活动id [ require false ]
     * @support  int $activityMemberParentId 活动成员的上级id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrderV1 ($context) {
        return self::getClass()->createOrderV1([
            "context" => $context,
        ]);
    }

    /**
     * 订单详情.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $orderDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO
     */
    public static function detailV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $orderDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detailV1($orderDetailCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO"
        );
    }


    /**
     * 订单列表.v1
     *
     * @support  string $status 订单状态- total:全部, submit:待支付, wait:待拍摄, process:当日拍摄, complete:已完成, close:已关闭 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listV1 ($context) {
        return self::getClass()->listV1([
            "context" => $context,
        ]);
    }

    /**
     * 用户取消订单.v1
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelV1 ($context) {
        return self::getClass()->cancelV1([
            "context" => $context,
        ]);
    }

    /**
     * 用户删除订单.v1
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteV1 ($context) {
        return self::getClass()->deleteV1([
            "context" => $context,
        ]);
    }

    /**
     * 订单退款.v1
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  array $reasonIds 退款原因ids [ require false ]
     * @support  string $reason 退款原因 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundV1 ($context) {
        return self::getClass()->refundV1([
            "context" => $context,
        ]);
    }

    /**
     * 修改预约时间.v1
     * @deprecated
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $reserveTime 新预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTimeV1 ($context) {
        return self::getClass()->changeReserveTimeV1([
            "context" => $context,
        ]);
    }

    /**
     * 退款理由.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRefundReasonV1 () {
        return self::getClass()->getRefundReasonV1();
    }

    /**
     * 用户消费门店.v1
     *
     * @throws  \Exception
     * @return  int[]
     */
    public static function getUserConsumeStoreIdsV1 ($context) {
        return self::getClass()->getUserConsumeStoreIdsV1();
    }

    /**
     * 修改预约V1
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $reserveTime 新预约时间 [ require true ]
     * @support  int $storeId 新预约门店ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeAppointmentV1 ($context) {
        return self::getClass()->changeAppointmentV1([
            "context" => $context,
        ]);
    }

    /**
     * 多门店下单.v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $createOrderCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderDTO[]
     */
    public static function createMultiOrderV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $createOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createMultiOrderV1($createOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}