<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\ShopCart;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBestMatchStoresByParams(array|ShopCart\GetBestMatchStores\BestMatchStoresCmd $params)
 */
class ShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取推荐门店
     *
     * @var  ShopCart\GetBestMatchStores\BestMatchStoresCmd $bestMatchStoresCmd $bestMatchStoresCmd
     * @throws  \Exception
     * @return  ShopCart\GetBestMatchStores\ProductBestMatchStoreDTO[]
     */
    public static function getBestMatchStores (ShopCart\GetBestMatchStores\BestMatchStoresCmd $bestMatchStoresCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getBestMatchStores($bestMatchStoresCmd),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\ShopCart\ShopCart\GetBestMatchStores\ProductBestMatchStoreDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'ShopCart\ShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'ShopCart\ShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}