<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getWxMiniSchemeByParams(array $params)
 * @method getWxMiniUrlLinkByParams(array $params)
 */
class Wx {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成小程序scheme码
     *
     * @support  string $appName 应用模块 [ require true ]
     * @support  int $expireTime 到期失效的 scheme 码的失效时间, 为 Unix 时间戳 require false
     * @support  array $jumpWxa 配置值 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWxMiniScheme () {
        return self::getClass()->getWxMiniScheme();
    }

    /**
     * 生成小程序UrlLink
     *
     * @support  string $appName 应用模块 [ require true ]
     * @support  string $path 通过 URL Link 进入的小程序页面路径，必须是已经发布的小程序存在的页面，不可携带 query [ require true ]
     * @support  string $query 通过 URL Link 进入小程序时的query，最大1024个字符 require false
     * @support  int $expireType 小程序 URL Link 失效类型 require false
     * @support  int $expireTime 到期失效的 URL Link 的失效时间, 为 Unix 时间戳 require false
     * @support  int $expireInterval 到期失效的URL Link的失效间隔天数 require false
     * @support  array $cloudBase 云开发静态网站自定义 H5 配置参数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWxMiniUrlLink () {
        return self::getClass()->getWxMiniUrlLink();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Common\Wx');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Common\Wx');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}