<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listPhotoAlbumsByParams(array $params)
 * @method createSharePhotoRecordByParams(array|PhotoAlbum\CreateSharePhotoRecord\CreateSharePhotoRecordCmd $params)
 * @method updateSharePhotoRecordByParams(array|PhotoAlbum\UpdateSharePhotoRecord\UpdateSharePhotoRecordCmd $params)
 * @method getShareRecordDetailByParams(array $params)
 * @method saveSharePhotosByParams(array $params)
 * @method getPictureMeasureByParams(array $params)
 * @method getPictureTypeByParams(array $params)
 * @method listPhotoAlbumsV1ByParams(array $params)
 * @method createSharePhotoRecordV1ByParams(array|PhotoAlbum\CreateSharePhotoRecordV1\CreateSharePhotoRecordCmd $params)
 * @method getShareRecordDetailV1ByParams(array $params)
 * @method saveSharePhotosV1ByParams(array $params)
 * @method getPictureTypeV1ByParams(array $params)
 */
class PhotoAlbum {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 我的相册
     *
     * @support  int $page 页码 require false
     * @support  int $pageSize 分页数 require false
     * @support  string $lastOrderReserveTime 上一页最后预约时间 require false
     * @throws  \Exception
     * @return  PhotoAlbum\ListPhotoAlbums\PhotoAlbumListDTO
     */
    public static function listPhotoAlbums () {
        return self::getClass()->listPhotoAlbums();
    }

    /**
     * 相册分享记录.创建
     *
     * @var  PhotoAlbum\CreateSharePhotoRecord\CreateSharePhotoRecordCmd $createSharePhotoRecordCmd $createSharePhotoRecordCmd
     * @throws  \Exception
     * @return  PhotoAlbum\CreateSharePhotoRecord\CreateSharePhotoRecordDTO
     */
    public static function createSharePhotoRecord (PhotoAlbum\CreateSharePhotoRecord\CreateSharePhotoRecordCmd $createSharePhotoRecordCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->createSharePhotoRecord($createSharePhotoRecordCmd),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\User\PhotoAlbum\CreateSharePhotoRecord\CreateSharePhotoRecordDTO"
        );
    }


    /**
     * 相册分享记录.更新
     *
     * @var  PhotoAlbum\UpdateSharePhotoRecord\UpdateSharePhotoRecordCmd $updateSharePhotoRecordCmd $updateSharePhotoRecordCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateSharePhotoRecord (PhotoAlbum\UpdateSharePhotoRecord\UpdateSharePhotoRecordCmd $updateSharePhotoRecordCmd) {
        return self::getClass()->updateSharePhotoRecord($updateSharePhotoRecordCmd);
    }


    /**
     * 分享记录详情
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  PhotoAlbum\GetShareRecordDetail\SharePhotoRecordDetailDTO
     */
    public static function getShareRecordDetail () {
        return self::getClass()->getShareRecordDetail();
    }

    /**
     * 保存分享数据到我的相册
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  PhotoAlbum\SaveSharePhotos\SaveSharePhotosDTO
     */
    public static function saveSharePhotos () {
        return self::getClass()->saveSharePhotos();
    }

    /**
     * 获取照片裁剪尺寸信息
     *
     * @throws  \Exception
     * @return  PhotoAlbum\GetPictureMeasure\PictureMeasureDetailDTO[]
     */
    public static function getPictureMeasure () {
        return self::getClass()->getPictureMeasure();
    }

    /**
     * 获得图片类型
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $photoVersionId 图片版本id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getPictureType (string $orderNum, string $photoVersionId) {
        return self::getClass()->getPictureType([
            "orderNum" => $orderNum,
            "photoVersionId" => $photoVersionId,
        ]);
    }

    /**
     * 我的相册.v1
     *
     * @support  int $page 页码 require false
     * @support  int $pageSize 分页数 require false
     * @support  string $lastOrderReserveTime 上一页最后预约时间 require false
     * @throws  \Exception
     * @return  PhotoAlbum\ListPhotoAlbumsV1\PhotoAlbumListDTO
     */
    public static function listPhotoAlbumsV1 () {
        return self::getClass()->listPhotoAlbumsV1();
    }

    /**
     * 相册分享记录.创建.v1
     *
     * @var  PhotoAlbum\CreateSharePhotoRecordV1\CreateSharePhotoRecordCmd $createSharePhotoRecordCmd $createSharePhotoRecordCmd
     * @throws  \Exception
     * @return  PhotoAlbum\CreateSharePhotoRecordV1\CreateSharePhotoRecordDTO
     */
    public static function createSharePhotoRecordV1 (PhotoAlbum\CreateSharePhotoRecordV1\CreateSharePhotoRecordCmd $createSharePhotoRecordCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->createSharePhotoRecordV1($createSharePhotoRecordCmd),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\User\PhotoAlbum\CreateSharePhotoRecordV1\CreateSharePhotoRecordDTO"
        );
    }


    /**
     * 分享记录详情.v1
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  PhotoAlbum\GetShareRecordDetailV1\SharePhotoRecordDetailDTO
     */
    public static function getShareRecordDetailV1 () {
        return self::getClass()->getShareRecordDetailV1();
    }

    /**
     * 保存分享数据到我的相册.v1
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  PhotoAlbum\SaveSharePhotosV1\SaveSharePhotosDTO
     */
    public static function saveSharePhotosV1 () {
        return self::getClass()->saveSharePhotosV1();
    }

    /**
     * 获得图片类型.v1
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $photoVersionId 图片版本id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getPictureTypeV1 (string $orderNum, string $photoVersionId) {
        return self::getClass()->getPictureTypeV1([
            "orderNum" => $orderNum,
            "photoVersionId" => $photoVersionId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\PhotoAlbum');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\PhotoAlbum');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}