<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method retailOrderRefundByParams(array|RetailOrder\RetailOrderRefund\RetailOrderRefundCmd $params)
 * @method retailOrderRefundReasonByParams(array $params)
 * @method retailOrderRefundV1ByParams(array|RetailOrder\RetailOrderRefundV1\RetailOrderRefundCmd $params)
 * @method retailOrderRefundReasonV1ByParams(array $params)
 */
class RetailOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售退款
     *
     * @var  RetailOrder\RetailOrderRefund\RetailOrderRefundCmd $retailOrderRefundCmd $retailOrderRefundCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function retailOrderRefund (RetailOrder\RetailOrderRefund\RetailOrderRefundCmd $retailOrderRefundCmd) {
        return self::getClass()->retailOrderRefund($retailOrderRefundCmd);
    }


    /**
     * 零售退款原因
     *
     * @throws  \Exception
     * @return  RetailOrder\RetailOrderRefundReason\RetailOrderReasonDTO[]
     */
    public static function retailOrderRefundReason () {
        return self::getClass()->retailOrderRefundReason();
    }

    /**
     * 零售退款V1
     *
     * @var  RetailOrder\RetailOrderRefundV1\RetailOrderRefundCmd $retailOrderRefundCmd $retailOrderRefundCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function retailOrderRefundV1 (RetailOrder\RetailOrderRefundV1\RetailOrderRefundCmd $retailOrderRefundCmd) {
        return self::getClass()->retailOrderRefundV1($retailOrderRefundCmd);
    }


    /**
     * 零售退款原因v1
     *
     * @throws  \Exception
     * @return  RetailOrder\RetailOrderRefundReasonV1\RetailOrderReasonDTO[]
     */
    public static function retailOrderRefundReasonV1 () {
        return self::getClass()->retailOrderRefundReasonV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'RetailOrder\RetailOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'RetailOrder\RetailOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}