<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Question;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSnStatusByParams(array $params)
 * @method getSnQuestionByParams(array $params)
 * @method createSnByParams(array|Sn\CreateSn\CreateSnCmd $params)
 */
class Sn {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取SN状态
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getSnStatus () {
        return self::getClass()->getSnStatus();
    }

    /**
     * 获取SN问卷
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  Sn\GetSnQuestion\QuestionInfoDTO[]
     */
    public static function getSnQuestion () {
        return self::getClass()->getSnQuestion();
    }

    /**
     * 提交SN问卷
     *
     * @var  Sn\CreateSn\CreateSnCmd $createSnCmd $createSnCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createSn (Sn\CreateSn\CreateSnCmd $createSnCmd) {
        return self::getClass()->createSn($createSnCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Question\Sn');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Question\Sn');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}