<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method encodeGroupOrderDetailByParams(array $params)
 * @method encodeRetailOrderDetailByParams(array $params)
 * @method encodeOfflineOrderDetailByParams(array $params)
 * @method getRetailOrderCodeByParams(array $params)
 * @method getRetailOrderCodeV1ByParams(array $params)
 */
class OrderOther {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取加密团购订单详情
     *
     * @param  string $groupOrderNum 团购订单编号 [ require true ]
     * @throws  \Exception
     * @return  OrderOther\EncodeGroupOrderDetail\GroupOrderDetailDTO
     */
    public static function encodeGroupOrderDetail (string $groupOrderNum) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->encodeGroupOrderDetail([
                            "groupOrderNum" => $groupOrderNum,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\Order\OrderOther\EncodeGroupOrderDetail\GroupOrderDetailDTO"
        );
    }

    /**
     * 获取加密零售订单详情
     *
     * @param  string $encodeOrderNum 加密的零售订单号 [ require true ]
     * @throws  \Exception
     * @return  OrderOther\EncodeRetailOrderDetail\RetailOrderDetailDTO
     */
    public static function encodeRetailOrderDetail (string $encodeOrderNum) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->encodeRetailOrderDetail([
                            "encodeOrderNum" => $encodeOrderNum,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\Order\OrderOther\EncodeRetailOrderDetail\RetailOrderDetailDTO"
        );
    }

    /**
     * 获取加密线下订单详情
     *
     * @param  string $encodeOrderNum 加密的线下订单号 [ require true ]
     * @throws  \Exception
     * @return  OrderOther\EncodeOfflineOrderDetail\OfflineOrderDetailDTO
     */
    public static function encodeOfflineOrderDetail (string $encodeOrderNum) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->encodeOfflineOrderDetail([
                            "encodeOrderNum" => $encodeOrderNum,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\Order\OrderOther\EncodeOfflineOrderDetail\OfflineOrderDetailDTO"
        );
    }

    /**
     * 获取零售订单提货码
     *
     * @param  string $orderNo 零售订单号 [ require true ]
     * @throws  \Exception
     * @return  OrderOther\GetRetailOrderCode\MemberRetailProductExchangeInfoDTO
     */
    public static function getRetailOrderCode (string $orderNo) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getRetailOrderCode([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\Order\OrderOther\GetRetailOrderCode\MemberRetailProductExchangeInfoDTO"
        );
    }

    /**
     * 获取零售订单提货码V1
     *
     * @param  string $orderNo 零售订单号 [ require true ]
     * @throws  \Exception
     * @return  OrderOther\GetRetailOrderCodeV1\MemberRetailProductExchangeInfoDTO
     */
    public static function getRetailOrderCodeV1 (string $orderNo) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getRetailOrderCodeV1([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\Order\OrderOther\GetRetailOrderCodeV1\MemberRetailProductExchangeInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\OrderOther');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\OrderOther');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}