<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method editUserInfoByParams(array|User\EditUserInfo\EditUserInfoCmd $params)
 * @method editUserTagByParams(array $params)
 * @method getProfessionsByParams(array $params)
 * @method getPreferencesByParams(array $params)
 * @method bindEmailByParams(array $params)
 * @method checkSignByParams(array $params)
 * @method sendCouponByParams(array $params)
 * @method setProtocolVersionByParams(array $params)
 * @method feedbackByParams(array $params)
 * @method changePasswordDirectByParams(array $params)
 * @method registerByParams(array|User\Register\RegisterCmd $params)
 * @method searchUserByUnionIdByParams(array $params)
 * @method detailV1ByParams(array $params)
 * @method editUserInfoV1ByParams(array|User\EditUserInfoV1\EditUserInfoCmd $params)
 * @method editUserTagV1ByParams(array $params)
 * @method getProfessionsV1ByParams(array $params)
 * @method getPreferencesV1ByParams(array $params)
 * @method setProtocolVersionV1ByParams(array $params)
 * @method feedbackV1ByParams(array $params)
 * @method changePasswordDirectV1ByParams(array $params)
 * @method forgetUserPasswordV1ByParams(array $params)
 * @method changUserPasswordV1ByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户详情
     *
     * @throws  \Exception
     * @return  User\Detail\UserDetailDTO
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 修改用户信息
     *
     * @var  User\EditUserInfo\EditUserInfoCmd $editUserInfoCmd $editUserInfoCmd
     * @throws  \Exception
     * @return  User\EditUserInfo\UserDetailDTO
     */
    public static function editUserInfo (User\EditUserInfo\EditUserInfoCmd $editUserInfoCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->editUserInfo($editUserInfoCmd),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\User\User\EditUserInfo\UserDetailDTO"
        );
    }


    /**
     * 修改用户标签
     *
     * @support  array $preference 偏好的数组 require false
     * @support  array $purpose 用途的数组 require false
     * @support  bool $enablePush 接受推送 require false
     * @throws  \Exception
     * @return  User\EditUserTag\UserDetailDTO
     */
    public static function editUserTag () {
        return self::getClass()->editUserTag();
    }

    /**
     * 职业列表
     *
     * @throws  \Exception
     * @return  User\GetProfessions\ProfessionInfoDTO[]
     */
    public static function getProfessions () {
        return self::getClass()->getProfessions();
    }

    /**
     * 偏好列表
     *
     * @throws  \Exception
     * @return  User\GetPreferences\PreferenceListDTO
     */
    public static function getPreferences () {
        return self::getClass()->getPreferences();
    }

    /**
     * 绑定邮箱
     *
     * @support  string $email 邮箱地址 [ require true ]
     * @support  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindEmail () {
        return self::getClass()->bindEmail();
    }

    /**
     * 绑定邮箱校验是否通过验证
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  int $user_id 用户uid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkSign (string $brand, int $user_id) {
        return self::getClass()->checkSign([
            "brand" => $brand,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 绑定邮箱发放优惠券
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  int $user_id 用户id [ require true ]
     * @param  string $choose 选择的券 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendCoupon (string $brand, int $user_id, string $choose) {
        return self::getClass()->sendCoupon([
            "brand" => $brand,
            "user_id" => $user_id,
            "choose" => $choose,
        ]);
    }

    /**
     * 记录预约协议版本
     *
     * @support  int $protocolVersion 预约协议版本 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setProtocolVersion () {
        return self::getClass()->setProtocolVersion();
    }

    /**
     * 用户意见反馈
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function feedback () {
        return self::getClass()->feedback();
    }

    /**
     * 更改密码（密码为空）
     *
     * @support  string $password 新密码 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function changePasswordDirect () {
        return self::getClass()->changePasswordDirect();
    }

    /**
     * 注册
     *
     * @var  User\Register\RegisterCmd $registerCmd $registerCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function register (User\Register\RegisterCmd $registerCmd) {
        return self::getClass()->register($registerCmd);
    }


    /**
     * 通过unionId判断用户是否在海马体平台注册过
     *
     * @support  string $unionId unionId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchUserByUnionId () {
        return self::getClass()->searchUserByUnionId();
    }

    /**
     * 用户详情.v1
     *
     * @throws  \Exception
     * @return  User\DetailV1\UserDetailDTO
     */
    public static function detailV1 () {
        return self::getClass()->detailV1();
    }

    /**
     * 修改用户信息.v1
     *
     * @var  User\EditUserInfoV1\EditUserInfoCmd $editUserInfoCmd $editUserInfoCmd
     * @throws  \Exception
     * @return  User\EditUserInfoV1\UserDetailDTO
     */
    public static function editUserInfoV1 (User\EditUserInfoV1\EditUserInfoCmd $editUserInfoCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->editUserInfoV1($editUserInfoCmd),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\User\User\EditUserInfoV1\UserDetailDTO"
        );
    }


    /**
     * 修改用户标签.v1
     *
     * @support  array $preference 偏好的数组 require false
     * @support  array $purpose 用途的数组 require false
     * @support  bool $enablePush 接受推送 require false
     * @throws  \Exception
     * @return  User\EditUserTagV1\UserDetailDTO
     */
    public static function editUserTagV1 () {
        return self::getClass()->editUserTagV1();
    }

    /**
     * 职业列表.v1
     *
     * @throws  \Exception
     * @return  User\GetProfessionsV1\ProfessionInfoDTO[]
     */
    public static function getProfessionsV1 () {
        return self::getClass()->getProfessionsV1();
    }

    /**
     * 偏好列表.v1
     *
     * @throws  \Exception
     * @return  User\GetPreferencesV1\PreferenceListDTO
     */
    public static function getPreferencesV1 () {
        return self::getClass()->getPreferencesV1();
    }

    /**
     * 记录预约协议版本.v1
     *
     * @support  int $protocolVersion 预约协议版本 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setProtocolVersionV1 () {
        return self::getClass()->setProtocolVersionV1();
    }

    /**
     * 用户意见反馈.v1
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function feedbackV1 () {
        return self::getClass()->feedbackV1();
    }

    /**
     * 更改密码（密码为空）.v1
     *
     * @support  string $password 新密码 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function changePasswordDirectV1 () {
        return self::getClass()->changePasswordDirectV1();
    }

    /**
     * 通过验证码更改登录密码.v1
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $password 新密码 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function forgetUserPasswordV1 (string $phone, string $password, string $captcha) {
        return self::getClass()->forgetUserPasswordV1([
            "phone" => $phone,
            "password" => $password,
            "captcha" => $captcha,
        ]);
    }

    /**
     * 更改密码.v1
     *
     * @param  string $password 旧密码 [ require true ]
     * @param  string $passwordNew 新密码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changUserPasswordV1 (string $password, string $passwordNew) {
        return self::getClass()->changUserPasswordV1([
            "password" => $password,
            "passwordNew" => $passwordNew,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}