<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMedalListByParams(array $params)
 * @method getMedalShowListByParams(array $params)
 * @method cancelMedalAlertRecordByParams(array $params)
 * @method getMedalDetailByParams(array $params)
 * @method getMedalListV1ByParams(array $params)
 * @method getMedalShowListV1ByParams(array $params)
 * @method cancelMedalAlertRecordV1ByParams(array $params)
 * @method getMedalDetailV1ByParams(array $params)
 */
class Medal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 勋章列表.勋章墙
     *
     * @param  bool $withAllLight 获取所有已点亮勋章 [ require true ]
     * @param  int $userId 当前登录userId, 非传递值，x-stream-id自动获取 [ require true ]
     * @throws  \Exception
     * @return  Medal\GetMedalList\MedalSeriesListDTO
     */
    public static function getMedalList (bool $withAllLight = false, int $userId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getMedalList([
                            "withAllLight" => $withAllLight,
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\User\Medal\GetMedalList\MedalSeriesListDTO"
        );
    }

    /**
     * 勋章列表.新点亮
     *
     * @throws  \Exception
     * @return  Medal\GetMedalShowList\MedalInfoDTO[]
     */
    public static function getMedalShowList () {
        return self::getClass()->getMedalShowList();
    }

    /**
     * 取消勋章弹框
     *
     * @support  array $recordIds 领取记录ids require false
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelMedalAlertRecord () {
        return self::getClass()->cancelMedalAlertRecord();
    }

    /**
     * 勋章详情
     *
     * @support  int $parentId 一级勋章id require false
     * @support  int $id 一级或二级勋章id require false
     * @throws  \Exception
     * @return  Medal\GetMedalDetail\MedalInfoDTO
     */
    public static function getMedalDetail () {
        return self::getClass()->getMedalDetail();
    }

    /**
     * 勋章列表.勋章墙.v1
     *
     * @param  bool $withAllLight 获取所有已点亮勋章 [ require true ]
     * @param  int $userId 当前登录userId, 非传递值，x-stream-id自动获取 [ require true ]
     * @throws  \Exception
     * @return  Medal\GetMedalListV1\MedalSeriesListDTO
     */
    public static function getMedalListV1 (bool $withAllLight = false, int $userId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getMedalListV1([
                            "withAllLight" => $withAllLight,
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\User\Medal\GetMedalListV1\MedalSeriesListDTO"
        );
    }

    /**
     * 勋章列表.新点亮.v1
     *
     * @throws  \Exception
     * @return  Medal\GetMedalShowListV1\MedalInfoDTO[]
     */
    public static function getMedalShowListV1 () {
        return self::getClass()->getMedalShowListV1();
    }

    /**
     * 取消勋章弹框.v1
     *
     * @support  array $recordIds 领取记录ids require false
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelMedalAlertRecordV1 () {
        return self::getClass()->cancelMedalAlertRecordV1();
    }

    /**
     * 勋章详情.v1
     *
     * @support  int $parentId 一级勋章id require false
     * @support  int $id 一级或二级勋章id require false
     * @throws  \Exception
     * @return  Medal\GetMedalDetailV1\MedalInfoDTO
     */
    public static function getMedalDetailV1 () {
        return self::getClass()->getMedalDetailV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\Medal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\Medal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}