<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method productDiscountByParams(array $params)
 * @method productDiscountV1ByParams(array $params)
 */
class ProductDiscount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店折扣详情
     *
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productDiscount () {
        return self::getClass()->productDiscount();
    }

    /**
     * 获取门店折扣详情.v1
     *
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productDiscountV1 () {
        return self::getClass()->productDiscountV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Product\ProductDiscount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Product\ProductDiscount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}