<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method receivePointsByParams(array $params)
 * @method changeMemberLevelByParams(array $params)
 * @method changeMemberPointsByParams(array $params)
 * @method sendMemberCouponByParams(array $params)
 */
class UserMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 领取积分
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $type 活动类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receivePoints (int $userId, string $type) {
        return self::getClass()->receivePoints([
            "userId" => $userId,
            "type" => $type,
        ]);
    }

    /**
     * 会员升级hook
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $change 升降级类型 [ require true ]
     * @param  string $originLevel 原等级 [ require true ]
     * @param  string $currentLevel 当前等级 [ require true ]
     * @param  bool $isReview 是否为复审 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeMemberLevel (int $userId = 0, string $change = '', string $originLevel = '', string $currentLevel = '', bool $isReview = false) {
        return self::getClass()->changeMemberLevel([
            "userId" => $userId,
            "change" => $change,
            "originLevel" => $originLevel,
            "currentLevel" => $currentLevel,
            "isReview" => $isReview,
        ]);
    }

    /**
     * 积分变更hook
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  float $points 积分 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeMemberPoints (int $userId = 0, string $type = '', float $points = 0.0) {
        return self::getClass()->changeMemberPoints([
            "userId" => $userId,
            "type" => $type,
            "points" => $points,
        ]);
    }

    /**
     * 发送会员加修加印券hook
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendMemberCoupon (int $orderId, int $userId = 0) {
        return self::getClass()->sendMemberCoupon([
            "orderId" => $orderId,
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\UserMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\UserMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}