<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method couponListByParams(array|Coupon\CouponList\CouponListCmd $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 优惠券列表
     *
     * @var  Coupon\CouponList\CouponListCmd $couponListCmd $couponListCmd
     * @throws  \Exception
     * @return  Coupon\CouponList\CouponListDTO
     */
    public static function couponList (Coupon\CouponList\CouponListCmd $couponListCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->couponList($couponListCmd),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\Preferential\Coupon\CouponList\CouponListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Preferential\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Preferential\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}