<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method searchByParams(array $params)
 */
class InvoiceTitle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加公司抬头
     *
     * @support  string $code 加密订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑公司抬头
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取公司抬头列表
     *
     * @support  string $type 加密订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 编辑公司抬头列表
     *
     * @support  string $code 加密订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 搜索公司抬头列表
     *
     * @support  string $title 公司抬头 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function search () {
        return self::getClass()->search();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\InvoiceTitle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\InvoiceTitle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}